package example.com.configurationorientationbug;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Button button = (Button) findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int orientation = getResources().getConfiguration().orientation;
                String text;
                switch (orientation) {
                    case Configuration.ORIENTATION_PORTRAIT:
                        text = "portrait";
                        break;
                    case Configuration.ORIENTATION_LANDSCAPE:
                        text = "landscape";
                        break;
                    default:
                        text = "unknown";
                        break;
                }
                Toast.makeText(MainActivity.this, text, Toast.LENGTH_SHORT).show();
            }
        });
    }

}
