/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.BundleCompat;
import android.support.v4.media.MediaBrowserCompatApi21;
import android.support.v4.media.MediaBrowserCompatApi23;
import android.support.v4.media.MediaBrowserCompatUtils;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class MediaBrowserCompat {
    private static final String TAG = "MediaBrowserCompat";
    public static final String EXTRA_PAGE = "android.media.browse.extra.PAGE";
    public static final String EXTRA_PAGE_SIZE = "android.media.browse.extra.PAGE_SIZE";
    private final MediaBrowserImpl mImpl;

    public MediaBrowserCompat(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
        this.mImpl = Build.VERSION.SDK_INT >= 23 ? new MediaBrowserImplApi23(context, serviceComponent, callback, rootHints) : (Build.VERSION.SDK_INT >= 21 ? new MediaBrowserImplApi21(context, serviceComponent, callback, rootHints) : new MediaBrowserServiceImplBase(context, serviceComponent, callback, rootHints));
    }

    public void connect() {
        this.mImpl.connect();
    }

    public void disconnect() {
        this.mImpl.disconnect();
    }

    public boolean isConnected() {
        return this.mImpl.isConnected();
    }

    @NonNull
    public ComponentName getServiceComponent() {
        return this.mImpl.getServiceComponent();
    }

    @NonNull
    public String getRoot() {
        return this.mImpl.getRoot();
    }

    @Nullable
    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    @NonNull
    public MediaSessionCompat.Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public void subscribe(@NonNull String parentId, @NonNull SubscriptionCallback callback) {
        this.mImpl.subscribe(parentId, null, callback);
    }

    public void subscribe(@NonNull String parentId, @NonNull Bundle options, @NonNull SubscriptionCallback callback) {
        if (options == null) {
            throw new IllegalArgumentException("options are null");
        }
        this.mImpl.subscribe(parentId, options, callback);
    }

    public void unsubscribe(@NonNull String parentId) {
        this.mImpl.unsubscribe(parentId, null);
    }

    public void unsubscribe(@NonNull String parentId, @NonNull Bundle options) {
        if (options == null) {
            throw new IllegalArgumentException("options are null");
        }
        this.mImpl.unsubscribe(parentId, options);
    }

    public void getItem(@NonNull String mediaId, @NonNull ItemCallback cb) {
        this.mImpl.getItem(mediaId, cb);
    }

    private static class ItemReceiver
    extends ResultReceiver {
        private final String mMediaId;
        private final ItemCallback mCallback;

        ItemReceiver(String mediaId, ItemCallback callback, Handler handler) {
            super(handler);
            this.mMediaId = mediaId;
            this.mCallback = callback;
        }

        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            resultData.setClassLoader(MediaBrowserCompat.class.getClassLoader());
            if (resultCode != 0 || resultData == null || !resultData.containsKey("media_item")) {
                this.mCallback.onError(this.mMediaId);
                return;
            }
            Parcelable item = resultData.getParcelable("media_item");
            if (item instanceof MediaItem) {
                this.mCallback.onItemLoaded((MediaItem)item);
            } else {
                this.mCallback.onError(this.mMediaId);
            }
        }
    }

    private static class ServiceBinderWrapper {
        private Messenger mMessenger;

        public ServiceBinderWrapper(IBinder target) {
            this.mMessenger = new Messenger(target);
        }

        void connect(Context context, Bundle rootHint, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_package_name", context.getPackageName());
            data.putBundle("data_root_hints", rootHint);
            this.sendRequest(1, data, callbacksMessenger);
        }

        void disconnect(Messenger callbacksMessenger) throws RemoteException {
            this.sendRequest(2, null, callbacksMessenger);
        }

        void addSubscription(String parentId, Bundle options, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_media_item_id", parentId);
            data.putBundle("data_options", options);
            this.sendRequest(3, data, callbacksMessenger);
        }

        void removeSubscription(String parentId, Bundle options, Messenger callbacksMessenger) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_media_item_id", parentId);
            data.putBundle("data_options", options);
            this.sendRequest(4, data, callbacksMessenger);
        }

        void getMediaItem(String mediaId, ResultReceiver receiver) throws RemoteException {
            Bundle data = new Bundle();
            data.putString("data_media_item_id", mediaId);
            data.putParcelable("data_result_receiver", (Parcelable)receiver);
            this.sendRequest(5, data, null);
        }

        void registerCallbackMessenger(Messenger callbackMessenger) throws RemoteException {
            this.sendRequest(6, null, callbackMessenger);
        }

        private void sendRequest(int what, Bundle data, Messenger cbMessenger) throws RemoteException {
            Message msg = Message.obtain();
            msg.what = what;
            msg.arg1 = 1;
            msg.setData(data);
            msg.replyTo = cbMessenger;
            this.mMessenger.send(msg);
        }
    }

    private static class CallbackHandler
    extends Handler {
        private final MediaBrowserServiceCallbackImpl mCallbackImpl;
        private WeakReference<Messenger> mCallbacksMessengerRef;

        CallbackHandler(MediaBrowserServiceCallbackImpl callbackImpl) {
            this.mCallbackImpl = callbackImpl;
        }

        public void handleMessage(Message msg) {
            if (this.mCallbacksMessengerRef == null) {
                return;
            }
            Bundle data = msg.getData();
            data.setClassLoader(MediaSessionCompat.class.getClassLoader());
            switch (msg.what) {
                case 1: {
                    this.mCallbackImpl.onServiceConnected((Messenger)this.mCallbacksMessengerRef.get(), data.getString("data_media_item_id"), (MediaSessionCompat.Token)data.getParcelable("data_media_session_token"), data.getBundle("data_root_hints"));
                    break;
                }
                case 2: {
                    this.mCallbackImpl.onConnectionFailed((Messenger)this.mCallbacksMessengerRef.get());
                    break;
                }
                case 3: {
                    this.mCallbackImpl.onLoadChildren((Messenger)this.mCallbacksMessengerRef.get(), data.getString("data_media_item_id"), data.getParcelableArrayList("data_media_item_list"), data.getBundle("data_options"));
                    break;
                }
                default: {
                    Log.w((String)MediaBrowserCompat.TAG, (String)("Unhandled message: " + msg + "\n  Client version: " + 1 + "\n  Service version: " + msg.arg1));
                }
            }
        }

        void setCallbacksMessenger(Messenger callbacksMessenger) {
            this.mCallbacksMessengerRef = new WeakReference<Messenger>(callbacksMessenger);
        }
    }

    private static class Subscription {
        private final List<SubscriptionCallback> mCallbacks = new ArrayList<SubscriptionCallback>();
        private final List<Bundle> mOptionsList = new ArrayList<Bundle>();

        public boolean isEmpty() {
            return this.mCallbacks.isEmpty();
        }

        public List<Bundle> getOptionsList() {
            return this.mOptionsList;
        }

        public List<SubscriptionCallback> getCallbacks() {
            return this.mCallbacks;
        }

        public void setCallbackForOptions(SubscriptionCallback callback, Bundle options) {
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                this.mCallbacks.set(i, callback);
                return;
            }
            this.mCallbacks.add(callback);
            this.mOptionsList.add(options);
        }

        public boolean remove(Bundle options) {
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                this.mCallbacks.remove(i);
                this.mOptionsList.remove(i);
                return true;
            }
            return false;
        }

        public SubscriptionCallback getCallback(Bundle options) {
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserCompatUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                return this.mCallbacks.get(i);
            }
            return null;
        }
    }

    static class MediaBrowserImplApi23
    extends MediaBrowserImplApi21 {
        public MediaBrowserImplApi23(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            super(context, serviceComponent, callback, rootHints);
        }

        @Override
        public void getItem(@NonNull String mediaId, @NonNull ItemCallback cb) {
            MediaBrowserCompatApi23.getItem((Object)this.mBrowserObj, (String)mediaId, (Object)cb.mItemCallbackObj);
        }
    }

    static class MediaBrowserImplApi21
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl,
    ConnectionCallback.ConnectionCallbackInternal {
        private static final boolean DBG = false;
        protected Object mBrowserObj;
        private final ComponentName mServiceComponent;
        private final CallbackHandler mHandler = new CallbackHandler(this);
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();
        private ServiceBinderWrapper mServiceBinderWrapper;
        private Messenger mCallbacksMessenger;

        public MediaBrowserImplApi21(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            this.mServiceComponent = serviceComponent;
            callback.setInternalConnectionCallback(this);
            this.mBrowserObj = MediaBrowserCompatApi21.createBrowser((Context)context, (ComponentName)serviceComponent, (Object)callback.mConnectionCallbackObj, (Bundle)rootHints);
        }

        @Override
        public void connect() {
            MediaBrowserCompatApi21.connect((Object)this.mBrowserObj);
        }

        @Override
        public void disconnect() {
            MediaBrowserCompatApi21.disconnect((Object)this.mBrowserObj);
        }

        @Override
        public boolean isConnected() {
            return MediaBrowserCompatApi21.isConnected((Object)this.mBrowserObj);
        }

        @Override
        public ComponentName getServiceComponent() {
            return MediaBrowserCompatApi21.getServiceComponent((Object)this.mBrowserObj);
        }

        @Override
        @NonNull
        public String getRoot() {
            return MediaBrowserCompatApi21.getRoot((Object)this.mBrowserObj);
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            return MediaBrowserCompatApi21.getExtras((Object)this.mBrowserObj);
        }

        @Override
        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            return MediaSessionCompat.Token.fromToken(MediaBrowserCompatApi21.getSessionToken((Object)this.mBrowserObj));
        }

        @Override
        public void subscribe(@NonNull String parentId, Bundle options, @NonNull SubscriptionCallback callback) {
            SubscriptionCallbackApi21 cb21 = new SubscriptionCallbackApi21(callback, options);
            Subscription sub = (Subscription)this.mSubscriptions.get(parentId);
            if (sub == null) {
                sub = new Subscription();
                this.mSubscriptions.put(parentId, sub);
            }
            sub.setCallbackForOptions(cb21, options);
            if (MediaBrowserCompatApi21.isConnected((Object)this.mBrowserObj)) {
                if (options == null || this.mServiceBinderWrapper == null) {
                    MediaBrowserCompatApi21.subscribe((Object)this.mBrowserObj, (String)parentId, (Object)cb21.mSubscriptionCallbackObj);
                } else {
                    try {
                        this.mServiceBinderWrapper.addSubscription(parentId, options, this.mCallbacksMessenger);
                    }
                    catch (RemoteException e) {
                        Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error subscribing media item: " + parentId));
                    }
                }
            }
        }

        @Override
        public void unsubscribe(@NonNull String parentId, Bundle options) {
            if (TextUtils.isEmpty((CharSequence)parentId)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            Subscription sub = (Subscription)this.mSubscriptions.get(parentId);
            if (sub != null && sub.remove(options)) {
                if (options == null || this.mServiceBinderWrapper == null) {
                    if (this.mServiceBinderWrapper != null || sub.isEmpty()) {
                        MediaBrowserCompatApi21.unsubscribe((Object)this.mBrowserObj, (String)parentId);
                    }
                } else if (this.mServiceBinderWrapper == null) {
                    try {
                        this.mServiceBinderWrapper.removeSubscription(parentId, options, this.mCallbacksMessenger);
                    }
                    catch (RemoteException e) {
                        Log.d((String)MediaBrowserCompat.TAG, (String)("removeSubscription failed with RemoteException parentId=" + parentId));
                    }
                }
            }
            if (sub != null && sub.isEmpty()) {
                this.mSubscriptions.remove(parentId);
            }
        }

        @Override
        public void getItem(final @NonNull String mediaId, final @NonNull ItemCallback cb) {
            if (TextUtils.isEmpty((CharSequence)mediaId)) {
                throw new IllegalArgumentException("mediaId is empty.");
            }
            if (cb == null) {
                throw new IllegalArgumentException("cb is null.");
            }
            if (!MediaBrowserCompatApi21.isConnected((Object)this.mBrowserObj)) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
                return;
            }
            if (this.mServiceBinderWrapper == null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onItemLoaded(null);
                    }
                });
                return;
            }
            ItemReceiver receiver = new ItemReceiver(mediaId, cb, this.mHandler);
            try {
                this.mServiceBinderWrapper.getMediaItem(mediaId, receiver);
            }
            catch (RemoteException e) {
                Log.i((String)MediaBrowserCompat.TAG, (String)("Remote error getting media item: " + mediaId));
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
            }
        }

        @Override
        public void onConnected() {
            Bundle extras = MediaBrowserCompatApi21.getExtras((Object)this.mBrowserObj);
            if (extras == null) {
                return;
            }
            IBinder serviceBinder = BundleCompat.getBinder(extras, "extra_messenger");
            if (serviceBinder != null) {
                this.mServiceBinderWrapper = new ServiceBinderWrapper(serviceBinder);
                this.mCallbacksMessenger = new Messenger((Handler)this.mHandler);
                this.mHandler.setCallbacksMessenger(this.mCallbacksMessenger);
                try {
                    this.mServiceBinderWrapper.registerCallbackMessenger(this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error registering client messenger.");
                }
                this.onServiceConnected(this.mCallbacksMessenger, null, null, null);
            }
        }

        @Override
        public void onConnectionSuspended() {
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
        }

        @Override
        public void onConnectionFailed() {
        }

        @Override
        public void onServiceConnected(Messenger callback, String root, MediaSessionCompat.Token session, Bundle extra) {
            for (Map.Entry<String, Subscription> subscriptionEntry : this.mSubscriptions.entrySet()) {
                String id = subscriptionEntry.getKey();
                Subscription sub = subscriptionEntry.getValue();
                List<Bundle> optionsList = sub.getOptionsList();
                List<SubscriptionCallback> callbackList = sub.getCallbacks();
                for (int i = 0; i < optionsList.size(); ++i) {
                    if (optionsList.get(i) == null) {
                        MediaBrowserCompatApi21.subscribe((Object)this.mBrowserObj, (String)id, (Object)((SubscriptionCallbackApi21)callbackList.get(i)).mSubscriptionCallbackObj);
                        continue;
                    }
                    try {
                        this.mServiceBinderWrapper.addSubscription(id, optionsList.get(i), this.mCallbacksMessenger);
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.d((String)MediaBrowserCompat.TAG, (String)("addSubscription failed with RemoteException parentId=" + id));
                    }
                }
            }
        }

        @Override
        public void onConnectionFailed(Messenger callback) {
        }

        @Override
        public void onLoadChildren(Messenger callback, String parentId, List list, @NonNull Bundle options) {
            if (this.mCallbacksMessenger != callback) {
                return;
            }
            List data = list;
            Subscription subscription = (Subscription)this.mSubscriptions.get(parentId);
            if (subscription == null) {
                return;
            }
            subscription.getCallback(options).onChildrenLoaded(parentId, data, options);
        }
    }

    static class MediaBrowserServiceImplBase
    implements MediaBrowserImpl,
    MediaBrowserServiceCallbackImpl {
        private static final boolean DBG = false;
        private static final int CONNECT_STATE_DISCONNECTED = 0;
        private static final int CONNECT_STATE_CONNECTING = 1;
        private static final int CONNECT_STATE_CONNECTED = 2;
        private static final int CONNECT_STATE_SUSPENDED = 3;
        private final Context mContext;
        private final ComponentName mServiceComponent;
        private final ConnectionCallback mCallback;
        private final Bundle mRootHints;
        private final CallbackHandler mHandler = new CallbackHandler(this);
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();
        private int mState = 0;
        private MediaServiceConnection mServiceConnection;
        private ServiceBinderWrapper mServiceBinderWrapper;
        private Messenger mCallbacksMessenger;
        private String mRootId;
        private MediaSessionCompat.Token mMediaSessionToken;
        private Bundle mExtras;

        public MediaBrowserServiceImplBase(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
            if (serviceComponent == null) {
                throw new IllegalArgumentException("service component must not be null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("connection callback must not be null");
            }
            this.mContext = context;
            this.mServiceComponent = serviceComponent;
            this.mCallback = callback;
            this.mRootHints = rootHints;
        }

        @Override
        public void connect() {
            if (this.mState != 0) {
                throw new IllegalStateException("connect() called while not disconnected (state=" + MediaBrowserServiceImplBase.getStateLabel(this.mState) + ")");
            }
            if (this.mServiceBinderWrapper != null) {
                throw new RuntimeException("mServiceBinderWrapper should be null. Instead it is " + this.mServiceBinderWrapper);
            }
            if (this.mCallbacksMessenger != null) {
                throw new RuntimeException("mCallbacksMessenger should be null. Instead it is " + this.mCallbacksMessenger);
            }
            this.mState = 1;
            Intent intent = new Intent("android.media.browse.MediaBrowserService");
            intent.setComponent(this.mServiceComponent);
            final MediaServiceConnection thisConnection = this.mServiceConnection = new MediaServiceConnection();
            boolean bound = false;
            try {
                bound = this.mContext.bindService(intent, (ServiceConnection)this.mServiceConnection, 1);
            }
            catch (Exception ex) {
                Log.e((String)MediaBrowserCompat.TAG, (String)("Failed binding to service " + this.mServiceComponent));
            }
            if (!bound) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (thisConnection == MediaBrowserServiceImplBase.this.mServiceConnection) {
                            MediaBrowserServiceImplBase.this.forceCloseConnection();
                            MediaBrowserServiceImplBase.this.mCallback.onConnectionFailed();
                        }
                    }
                });
            }
        }

        @Override
        public void disconnect() {
            if (this.mCallbacksMessenger != null) {
                try {
                    this.mServiceBinderWrapper.disconnect(this.mCallbacksMessenger);
                }
                catch (RemoteException ex) {
                    Log.w((String)MediaBrowserCompat.TAG, (String)("RemoteException during connect for " + this.mServiceComponent));
                }
            }
            this.forceCloseConnection();
        }

        private void forceCloseConnection() {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
            }
            this.mState = 0;
            this.mServiceConnection = null;
            this.mServiceBinderWrapper = null;
            this.mCallbacksMessenger = null;
            this.mRootId = null;
            this.mMediaSessionToken = null;
        }

        @Override
        public boolean isConnected() {
            return this.mState == 2;
        }

        @Override
        @NonNull
        public ComponentName getServiceComponent() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
            }
            return this.mServiceComponent;
        }

        @Override
        @NonNull
        public String getRoot() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getRoot() called while not connected(state=" + MediaBrowserServiceImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mRootId;
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowserServiceImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mExtras;
        }

        @Override
        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getSessionToken() called while not connected(state=" + this.mState + ")");
            }
            return this.mMediaSessionToken;
        }

        @Override
        public void subscribe(@NonNull String parentId, Bundle options, @NonNull SubscriptionCallback callback) {
            if (TextUtils.isEmpty((CharSequence)parentId)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            if (callback == null) {
                throw new IllegalArgumentException("callback is null");
            }
            Subscription sub = (Subscription)this.mSubscriptions.get(parentId);
            if (sub == null) {
                sub = new Subscription();
                this.mSubscriptions.put(parentId, sub);
            }
            sub.setCallbackForOptions(callback, options);
            if (this.mState == 2) {
                try {
                    this.mServiceBinderWrapper.addSubscription(parentId, options, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("addSubscription failed with RemoteException parentId=" + parentId));
                }
            }
        }

        @Override
        public void unsubscribe(@NonNull String parentId, Bundle options) {
            if (TextUtils.isEmpty((CharSequence)parentId)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            Subscription sub = (Subscription)this.mSubscriptions.get(parentId);
            if (sub != null && sub.remove(options) && this.mState == 2) {
                try {
                    this.mServiceBinderWrapper.removeSubscription(parentId, options, this.mCallbacksMessenger);
                }
                catch (RemoteException e) {
                    Log.d((String)MediaBrowserCompat.TAG, (String)("removeSubscription failed with RemoteException parentId=" + parentId));
                }
            }
            if (sub != null && sub.isEmpty()) {
                this.mSubscriptions.remove(parentId);
            }
        }

        @Override
        public void getItem(final @NonNull String mediaId, final @NonNull ItemCallback cb) {
            if (TextUtils.isEmpty((CharSequence)mediaId)) {
                throw new IllegalArgumentException("mediaId is empty.");
            }
            if (cb == null) {
                throw new IllegalArgumentException("cb is null.");
            }
            if (this.mState != 2) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
                return;
            }
            ItemReceiver receiver = new ItemReceiver(mediaId, cb, this.mHandler);
            try {
                this.mServiceBinderWrapper.getMediaItem(mediaId, receiver);
            }
            catch (RemoteException e) {
                Log.i((String)MediaBrowserCompat.TAG, (String)"Remote error getting media item.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
            }
        }

        @Override
        public void onServiceConnected(Messenger callback, String root, MediaSessionCompat.Token session, Bundle extra) {
            if (!this.isCurrent(callback, "onConnect")) {
                return;
            }
            if (this.mState != 1) {
                Log.w((String)MediaBrowserCompat.TAG, (String)("onConnect from service while mState=" + MediaBrowserServiceImplBase.getStateLabel(this.mState) + "... ignoring"));
                return;
            }
            this.mRootId = root;
            this.mMediaSessionToken = session;
            this.mExtras = extra;
            this.mState = 2;
            this.mCallback.onConnected();
            try {
                for (Map.Entry<String, Subscription> subscriptionEntry : this.mSubscriptions.entrySet()) {
                    String id = subscriptionEntry.getKey();
                    Subscription sub = subscriptionEntry.getValue();
                    for (Bundle options : sub.getOptionsList()) {
                        this.mServiceBinderWrapper.addSubscription(id, options, this.mCallbacksMessenger);
                    }
                }
            }
            catch (RemoteException ex) {
                Log.d((String)MediaBrowserCompat.TAG, (String)"addSubscription failed with RemoteException.");
            }
        }

        @Override
        public void onConnectionFailed(Messenger callback) {
            Log.e((String)MediaBrowserCompat.TAG, (String)("onConnectFailed for " + this.mServiceComponent));
            if (!this.isCurrent(callback, "onConnectFailed")) {
                return;
            }
            if (this.mState != 1) {
                Log.w((String)MediaBrowserCompat.TAG, (String)("onConnect from service while mState=" + MediaBrowserServiceImplBase.getStateLabel(this.mState) + "... ignoring"));
                return;
            }
            this.forceCloseConnection();
            this.mCallback.onConnectionFailed();
        }

        @Override
        public void onLoadChildren(Messenger callback, String parentId, List list, Bundle options) {
            if (!this.isCurrent(callback, "onLoadChildren")) {
                return;
            }
            List data = list;
            Subscription subscription = (Subscription)this.mSubscriptions.get(parentId);
            if (subscription == null) {
                return;
            }
            SubscriptionCallback subscriptionCallback = subscription.getCallback(options);
            if (subscriptionCallback != null) {
                if (options == null) {
                    subscriptionCallback.onChildrenLoaded(parentId, data);
                } else {
                    subscriptionCallback.onChildrenLoaded(parentId, data, options);
                }
            }
        }

        private static String getStateLabel(int state) {
            switch (state) {
                case 0: {
                    return "CONNECT_STATE_DISCONNECTED";
                }
                case 1: {
                    return "CONNECT_STATE_CONNECTING";
                }
                case 2: {
                    return "CONNECT_STATE_CONNECTED";
                }
                case 3: {
                    return "CONNECT_STATE_SUSPENDED";
                }
            }
            return "UNKNOWN/" + state;
        }

        private boolean isCurrent(Messenger callback, String funcName) {
            if (this.mCallbacksMessenger != callback) {
                if (this.mState != 0) {
                    Log.i((String)MediaBrowserCompat.TAG, (String)(funcName + " for " + this.mServiceComponent + " with mCallbacksMessenger=" + this.mCallbacksMessenger + " this=" + this));
                }
                return false;
            }
            return true;
        }

        void dump() {
            Log.d((String)MediaBrowserCompat.TAG, (String)"MediaBrowserCompat...");
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceComponent=" + this.mServiceComponent));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mCallback=" + this.mCallback));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mRootHints=" + this.mRootHints));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mState=" + MediaBrowserServiceImplBase.getStateLabel(this.mState)));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceConnection=" + this.mServiceConnection));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mServiceBinderWrapper=" + this.mServiceBinderWrapper));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mCallbacksMessenger=" + this.mCallbacksMessenger));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mRootId=" + this.mRootId));
            Log.d((String)MediaBrowserCompat.TAG, (String)("  mMediaSessionToken=" + this.mMediaSessionToken));
        }

        private class MediaServiceConnection
        implements ServiceConnection {
            private MediaServiceConnection() {
            }

            public void onServiceConnected(final ComponentName name, final IBinder binder) {
                this.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        if (!MediaServiceConnection.this.isCurrent("onServiceConnected")) {
                            return;
                        }
                        MediaBrowserServiceImplBase.this.mServiceBinderWrapper = new ServiceBinderWrapper(binder);
                        MediaBrowserServiceImplBase.this.mCallbacksMessenger = new Messenger((Handler)MediaBrowserServiceImplBase.this.mHandler);
                        MediaBrowserServiceImplBase.this.mHandler.setCallbacksMessenger(MediaBrowserServiceImplBase.this.mCallbacksMessenger);
                        MediaBrowserServiceImplBase.this.mState = 1;
                        try {
                            MediaBrowserServiceImplBase.this.mServiceBinderWrapper.connect(MediaBrowserServiceImplBase.this.mContext, MediaBrowserServiceImplBase.this.mRootHints, MediaBrowserServiceImplBase.this.mCallbacksMessenger);
                        }
                        catch (RemoteException ex) {
                            Log.w((String)MediaBrowserCompat.TAG, (String)("RemoteException during connect for " + MediaBrowserServiceImplBase.this.mServiceComponent));
                        }
                    }
                });
            }

            public void onServiceDisconnected(final ComponentName name) {
                this.postOrRun(new Runnable(){

                    @Override
                    public void run() {
                        if (!MediaServiceConnection.this.isCurrent("onServiceDisconnected")) {
                            return;
                        }
                        MediaBrowserServiceImplBase.this.mServiceBinderWrapper = null;
                        MediaBrowserServiceImplBase.this.mCallbacksMessenger = null;
                        MediaBrowserServiceImplBase.this.mHandler.setCallbacksMessenger(null);
                        MediaBrowserServiceImplBase.this.mState = 3;
                        MediaBrowserServiceImplBase.this.mCallback.onConnectionSuspended();
                    }
                });
            }

            private void postOrRun(Runnable r) {
                if (Thread.currentThread() == MediaBrowserServiceImplBase.this.mHandler.getLooper().getThread()) {
                    r.run();
                } else {
                    MediaBrowserServiceImplBase.this.mHandler.post(r);
                }
            }

            private boolean isCurrent(String funcName) {
                if (MediaBrowserServiceImplBase.this.mServiceConnection != this) {
                    if (MediaBrowserServiceImplBase.this.mState != 0) {
                        Log.i((String)MediaBrowserCompat.TAG, (String)(funcName + " for " + MediaBrowserServiceImplBase.this.mServiceComponent + " with mServiceConnection=" + MediaBrowserServiceImplBase.this.mServiceConnection + " this=" + this));
                    }
                    return false;
                }
                return true;
            }
        }
    }

    static interface MediaBrowserServiceCallbackImpl {
        public void onServiceConnected(Messenger var1, String var2, MediaSessionCompat.Token var3, Bundle var4);

        public void onConnectionFailed(Messenger var1);

        public void onLoadChildren(Messenger var1, String var2, List var3, Bundle var4);
    }

    static interface MediaBrowserImpl {
        public void connect();

        public void disconnect();

        public boolean isConnected();

        public ComponentName getServiceComponent();

        @NonNull
        public String getRoot();

        @Nullable
        public Bundle getExtras();

        @NonNull
        public MediaSessionCompat.Token getSessionToken();

        public void subscribe(@NonNull String var1, Bundle var2, @NonNull SubscriptionCallback var3);

        public void unsubscribe(@NonNull String var1, Bundle var2);

        public void getItem(@NonNull String var1, @NonNull ItemCallback var2);
    }

    public static abstract class ItemCallback {
        final Object mItemCallbackObj = Build.VERSION.SDK_INT >= 23 ? MediaBrowserCompatApi23.createItemCallback((MediaBrowserCompatApi23.ItemCallback)new StubApi23()) : null;

        public void onItemLoaded(MediaItem item) {
        }

        public void onError(@NonNull String itemId) {
        }

        private class StubApi23
        implements MediaBrowserCompatApi23.ItemCallback {
            private StubApi23() {
            }

            public void onItemLoaded(Parcel itemParcel) {
                itemParcel.setDataPosition(0);
                MediaItem item = (MediaItem)MediaItem.CREATOR.createFromParcel(itemParcel);
                itemParcel.recycle();
                ItemCallback.this.onItemLoaded(item);
            }

            public void onError(@NonNull String itemId) {
                ItemCallback.this.onError(itemId);
            }
        }
    }

    static class SubscriptionCallbackApi21
    extends SubscriptionCallback {
        SubscriptionCallback mSubscriptionCallback;
        private final Object mSubscriptionCallbackObj;
        private Bundle mOptions;

        public SubscriptionCallbackApi21(SubscriptionCallback callback, Bundle options) {
            this.mSubscriptionCallback = callback;
            this.mOptions = options;
            this.mSubscriptionCallbackObj = MediaBrowserCompatApi21.createSubscriptionCallback((MediaBrowserCompatApi21.SubscriptionCallback)new StubApi21());
        }

        @Override
        public void onChildrenLoaded(@NonNull String parentId, List<MediaItem> children) {
            this.mSubscriptionCallback.onChildrenLoaded(parentId, children);
        }

        @Override
        public void onChildrenLoaded(@NonNull String parentId, List<MediaItem> children, @NonNull Bundle options) {
            this.mSubscriptionCallback.onChildrenLoaded(parentId, children, options);
        }

        @Override
        public void onError(@NonNull String parentId) {
            this.mSubscriptionCallback.onError(parentId);
        }

        @Override
        public void onError(@NonNull String parentId, @NonNull Bundle options) {
            this.mSubscriptionCallback.onError(parentId, options);
        }

        private class StubApi21
        implements MediaBrowserCompatApi21.SubscriptionCallback {
            private StubApi21() {
            }

            public void onChildrenLoaded(@NonNull String parentId, List<Parcel> children) {
                ArrayList<MediaItem> mediaItems = null;
                if (children != null) {
                    mediaItems = new ArrayList<MediaItem>();
                    for (Parcel parcel : children) {
                        parcel.setDataPosition(0);
                        mediaItems.add((MediaItem)MediaItem.CREATOR.createFromParcel(parcel));
                        parcel.recycle();
                    }
                }
                if (SubscriptionCallbackApi21.this.mOptions != null) {
                    SubscriptionCallbackApi21.this.onChildrenLoaded(parentId, MediaBrowserCompatUtils.applyOptions(mediaItems, SubscriptionCallbackApi21.this.mOptions), SubscriptionCallbackApi21.this.mOptions);
                } else {
                    SubscriptionCallbackApi21.this.onChildrenLoaded(parentId, mediaItems);
                }
            }

            public void onError(@NonNull String parentId) {
                if (SubscriptionCallbackApi21.this.mOptions != null) {
                    SubscriptionCallbackApi21.this.onError(parentId, SubscriptionCallbackApi21.this.mOptions);
                } else {
                    SubscriptionCallbackApi21.this.onError(parentId);
                }
            }
        }
    }

    public static abstract class SubscriptionCallback {
        public void onChildrenLoaded(@NonNull String parentId, List<MediaItem> children) {
        }

        public void onChildrenLoaded(@NonNull String parentId, List<MediaItem> children, @NonNull Bundle options) {
        }

        public void onError(@NonNull String parentId) {
        }

        public void onError(@NonNull String parentId, @NonNull Bundle options) {
        }
    }

    public static class ConnectionCallback {
        final Object mConnectionCallbackObj = Build.VERSION.SDK_INT >= 21 ? MediaBrowserCompatApi21.createConnectionCallback((MediaBrowserCompatApi21.ConnectionCallback)new StubApi21()) : null;
        private ConnectionCallbackInternal mConnectionCallbackInternal;

        public void onConnected() {
        }

        public void onConnectionSuspended() {
        }

        public void onConnectionFailed() {
        }

        void setInternalConnectionCallback(ConnectionCallbackInternal connectionCallbackInternal) {
            this.mConnectionCallbackInternal = connectionCallbackInternal;
        }

        private class StubApi21
        implements MediaBrowserCompatApi21.ConnectionCallback {
            private StubApi21() {
            }

            public void onConnected() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnected();
                }
                ConnectionCallback.this.onConnected();
            }

            public void onConnectionSuspended() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionSuspended();
                }
                ConnectionCallback.this.onConnectionSuspended();
            }

            public void onConnectionFailed() {
                if (ConnectionCallback.this.mConnectionCallbackInternal != null) {
                    ConnectionCallback.this.mConnectionCallbackInternal.onConnectionFailed();
                }
                ConnectionCallback.this.onConnectionFailed();
            }
        }

        static interface ConnectionCallbackInternal {
            public void onConnected();

            public void onConnectionSuspended();

            public void onConnectionFailed();
        }
    }

    public static class MediaItem
    implements Parcelable {
        private final int mFlags;
        private final MediaDescriptionCompat mDescription;
        public static final int FLAG_BROWSABLE = 1;
        public static final int FLAG_PLAYABLE = 2;
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            public MediaItem createFromParcel(Parcel in) {
                return new MediaItem(in);
            }

            public MediaItem[] newArray(int size) {
                return new MediaItem[size];
            }
        };

        public MediaItem(@NonNull MediaDescriptionCompat description, int flags) {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty((CharSequence)description.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = flags;
            this.mDescription = description;
        }

        private MediaItem(Parcel in) {
            this.mFlags = in.readInt();
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(in);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mFlags);
            this.mDescription.writeToParcel(out, flags);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MediaItem{");
            sb.append("mFlags=").append(this.mFlags);
            sb.append(", mDescription=").append(this.mDescription);
            sb.append('}');
            return sb.toString();
        }

        public int getFlags() {
            return this.mFlags;
        }

        public boolean isBrowsable() {
            return (this.mFlags & 1) != 0;
        }

        public boolean isPlayable() {
            return (this.mFlags & 2) != 0;
        }

        @NonNull
        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        @NonNull
        public String getMediaId() {
            return this.mDescription.getMediaId();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }
    }
}

