/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;

class AppCompatImageHelper {
    private final ImageView mView;
    private final AppCompatDrawableManager mDrawableManager;

    AppCompatImageHelper(ImageView view, AppCompatDrawableManager drawableManager) {
        this.mView = view;
        this.mDrawableManager = drawableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), attrs, R.styleable.AppCompatImageView, defStyleAttr, 0);
        try {
            Drawable drawable2;
            int id2;
            Drawable d = a.getDrawableIfKnown(R.styleable.AppCompatImageView_android_src);
            if (d != null) {
                this.mView.setImageDrawable(d);
            }
            if ((id2 = a.getResourceId(R.styleable.AppCompatImageView_srcCompat, -1)) != -1 && (d = this.mDrawableManager.getDrawable(this.mView.getContext(), id2)) != null) {
                this.mView.setImageDrawable(d);
            }
            if ((drawable2 = this.mView.getDrawable()) != null) {
                DrawableUtils.fixDrawable(drawable2);
            }
        }
        finally {
            a.recycle();
        }
    }

    void setImageResource(int resId) {
        if (resId != 0) {
            Drawable d;
            Drawable drawable2 = d = this.mDrawableManager != null ? this.mDrawableManager.getDrawable(this.mView.getContext(), resId) : ContextCompat.getDrawable((Context)this.mView.getContext(), (int)resId);
            if (d != null) {
                DrawableUtils.fixDrawable(d);
            }
            this.mView.setImageDrawable(d);
        } else {
            this.mView.setImageDrawable(null);
        }
    }
}

