package de.davidartmann.rosa.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ProgressBar;

import de.davidartmann.rosa.R;
import de.davidartmann.rosa.adapter.MainListAdapter;
import de.davidartmann.rosa.fragment.DetailEditFragment;
import de.davidartmann.rosa.fragment.DetailFragment;
import de.davidartmann.rosa.fragment.MainListArchivFragment;
import de.davidartmann.rosa.fragment.MainListFragment;
import de.davidartmann.rosa.model.Person;

public class MainListActivity extends AppCompatActivity implements MainListAdapter.IMainListAdapter,
        MainListArchivFragment.IMainListArchivFragment, MainListFragment.IMainListFragment {

    private static final String TAG = MainListActivity.class.getSimpleName();

    private int mNumberOfMainListItems;
    private ProgressBar progressBar;
    private String mArchivBackStackName;
    private String mDetailEditBackStackName;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mArchivBackStackName = MainListArchivFragment.class.getSimpleName();
        mDetailEditBackStackName = DetailEditFragment.class.getSimpleName();
        progressBar = (ProgressBar) findViewById(R.id.activity_main_progressbar);
        mNumberOfMainListItems = 0;
        Intent intent = getIntent();
        if (intent.getBooleanExtra(DetailFragment.EDIT, false)) {
            Person person = (Person) intent.getSerializableExtra(DetailFragment.PERSON);
            replaceFragment(DetailEditFragment.newInstanceForUpdate(person), false, null);
        } else {
            if (savedInstanceState == null) {
                replaceFragment(new MainListFragment(), false, null);
                progressBar.setVisibility(ProgressBar.VISIBLE);
            }
        }
    }

    public void replaceFragment(Fragment fragment, boolean backStackAllowed, String backStackName) {
        //TODO: backstack not working properly
        @SuppressLint("CommitTransaction") FragmentTransaction ft = getSupportFragmentManager()
                .beginTransaction()
                .replace(R.id.activity_main_framelayout, fragment);
        if (backStackAllowed) {
            ft.addToBackStack(backStackName);
        }
        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN)
                .commit();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_main_list, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.menu_main_add:
                replaceFragment(DetailEditFragment.newInstanceForCreate(mNumberOfMainListItems),
                        false, mDetailEditBackStackName);
                return true;
            case R.id.menu_main_search:
                //TODO: implement search
                return true;
            case R.id.menu_main_archive:
                replaceFragment(new MainListArchivFragment(), false, mArchivBackStackName);
                return true;
            case android.R.id.home:
                replaceFragment(new MainListFragment(), false, null);
                resetActionBar();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void resetActionBar() {
        ActionBar actionBar = getSupportActionBar();
        if (actionBar != null) {
            actionBar.setHomeButtonEnabled(false);
            actionBar.setDisplayHomeAsUpEnabled(false);
            actionBar.setTitle(R.string.app_name);
        }
    }

    @Override
    public void onBackPressed() {
        FragmentManager fragmentManager = getSupportFragmentManager();
        if (fragmentManager.getBackStackEntryCount() == 0) {
            finish();
        } else {
            /*
            int count = fragmentManager.getBackStackEntryCount();
            Log.d(TAG, "count "+count);
            if (count > 0) {
                String name = fragmentManager.getBackStackEntryAt(0).getName();
                Log.d(TAG, "name "+name);
                fragmentManager.popBackStack(name, FragmentManager.POP_BACK_STACK_INCLUSIVE);
            }
            */
            fragmentManager.popBackStack();
            resetActionBar();
            //fragmentManager.popBackStack(mArchivBackStackName, FragmentManager.POP_BACK_STACK_INCLUSIVE);
            //fragmentManager.popBackStack(mDetailEditBackStackName, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        }
    }

    @Override
    public void onInstanceCreated(int numberOfItems) {
        mNumberOfMainListItems = numberOfItems;
        progressBar.setVisibility(ProgressBar.INVISIBLE);
    }

    @Override
    public void onAllInactivePersonsDeleted(Integer numberOfDeletedPersons) {
        replaceFragment(new MainListFragment(), false, null);
        progressBar.setVisibility(ProgressBar.VISIBLE);
        resetActionBar();
        String deleteString;
        if (numberOfDeletedPersons == 1) {
            deleteString = " Person gelöscht";
        } else {
            deleteString = " Personen gelöscht";
        }
        Snackbar.make(this.findViewById(android.R.id.content),
                numberOfDeletedPersons + deleteString, Snackbar.LENGTH_LONG).show();
    }

    @Override
    public void onChoosenPersonsUnarchived() {
        replaceFragment(new MainListArchivFragment(), false, mArchivBackStackName);
    }

    @Override
    public void onChoosenPersonsSoftDeleted(int numberOfSoftDeletedPersons) {
        replaceFragment(new MainListFragment(), false, null);
        progressBar.setVisibility(ProgressBar.VISIBLE);
        resetActionBar();
        String deleteString;
        if (numberOfSoftDeletedPersons == 1) {
            deleteString = " Person archiviert";
        } else {
            deleteString = " Personen archiviert";
        }
        Snackbar.make(this.findViewById(android.R.id.content),
                numberOfSoftDeletedPersons + deleteString, Snackbar.LENGTH_LONG).show();
    }

    @Override
    public void onChosenPersonsDeleted(int numberOfDeletedPersons, Boolean isDeleted) {
        replaceFragment(new MainListFragment(), false, null);
        progressBar.setVisibility(ProgressBar.VISIBLE);
        resetActionBar();
        String deleteString;
        if (isDeleted) {
            if (numberOfDeletedPersons == 1) {
                deleteString = " Person archiviert";
            } else {
                deleteString = " Personen archiviert";
            }
            Snackbar.make(this.findViewById(android.R.id.content),
                    numberOfDeletedPersons + deleteString, Snackbar.LENGTH_LONG).show();
        } else {
            deleteString = "Konnte ausgewählte Personen nicht löschen";
            Snackbar.make(this.findViewById(android.R.id.content),
                    deleteString, Snackbar.LENGTH_LONG).show();
        }
    }

    @Override
    public void onMenuEditButtonClicked(Person person) {
        replaceFragment(DetailEditFragment.newInstanceForUpdate(person), false, null);
    }
}
