package de.davidartmann.rosa.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.davidartmann.rosa.R;
import de.davidartmann.rosa.adapter.viewholder.MainListViewholder;
import de.davidartmann.rosa.db.async.FindAllActivePersonsFromDb;
import de.davidartmann.rosa.model.Person;

/**
 * Adapter for the RecylcerView of the ListView.
 * Created by david on 29.02.16.
 */
public class MainListAdapter extends RecyclerView.Adapter<MainListViewholder>
        implements FindAllActivePersonsFromDb.IFindAllActive,
        MainListViewholder.IMainListViewholder {

    private static final String TAG = MainListAdapter.class.getSimpleName();

    private int mLayout;
    private List<Person> mPersons;
    private List<Person> mPersonsFiltered;
    private Context mContext;
    private IMainListAdapter iMainListAdapter;
    private boolean mIsLongClicked;
    private int mNumberOfPersons;
    private List<Person> mPersonsToArchive;
    private IMainFragmentLongClickMenu iMainFragmentLongClickMenu;
    public MainListAdapter(int layout, Context context, IMainListAdapter iMainListAdapter,
                           IMainFragmentLongClickMenu iMainFragmentLongClickMenu) {
        mLayout = layout;
        mPersons = new ArrayList<>();
        mPersonsFiltered = new ArrayList<>();
        mContext = context;
        this.iMainListAdapter = iMainListAdapter;
        new FindAllActivePersonsFromDb(context, this).execute();
        mIsLongClicked = false;
        mNumberOfPersons = 0;
        mPersonsToArchive = new ArrayList<>();
        this.iMainFragmentLongClickMenu = iMainFragmentLongClickMenu;
    }

    public boolean isLongClicked() {
        return mIsLongClicked;
    }

    public void setmIsLongClicked(boolean mIsLongClicked) {
        this.mIsLongClicked = mIsLongClicked;
    }

    @Override
    public MainListViewholder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(mLayout, parent, false);
        return new MainListViewholder(view, mContext, getItemCount(), this, this);
    }

    @Override
    public void onBindViewHolder(MainListViewholder holder, int position) {
        holder.assignData(mPersonsFiltered.get(position)/*mPersons.get(position)*/);
    }

    @Override
    public int getItemCount() {
        return mPersonsFiltered.size()/*mPersons.size()*/;
    }

    @Override
    public void onFindAllActive(List<Person> persons) {
        if (mPersons != null) {
            mPersons.clear();
            mPersons.addAll(persons);
        } else {
            mPersons = persons;
        }
        mPersonsFiltered = new ArrayList<>(mPersons);
        notifyDataSetChanged();
        iMainListAdapter.onInstanceCreated(getItemCount());
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public void onIncrementFinished() {
        new FindAllActivePersonsFromDb(mContext, this).execute();
    }

    @Override
    public void onLongClicked(int position, View view, Person person) {
        mIsLongClicked = true;
        view.setBackgroundColor(ContextCompat.getColor(mContext, R.color.colorLightGray));
        view.setElevation(1);
        mNumberOfPersons++;
        mPersonsToArchive.add(person);
        iMainFragmentLongClickMenu.onLongClicked(true, mPersonsToArchive);
    }

    @Override
    public void onClicked(int position, View view, Person person, int bgColor) {
        if (mIsLongClicked) {
            if (mNumberOfPersons != 0) {
                int colorBgGray = ContextCompat.getColor(mContext, R.color.colorLightGray);
                if (view.getElevation() == 1) {
                    view.setElevation(3);
                    setCardBackgroundByCategory(view, person);
                    mNumberOfPersons--;
                    mPersonsToArchive.remove(person);
                    if (mNumberOfPersons == 0) {
                        iMainFragmentLongClickMenu.onLongClicked(false, mPersonsToArchive);
                    }
                    if (mNumberOfPersons == 1) {
                        iMainFragmentLongClickMenu.onLongClicked(true, mPersonsToArchive);
                    }
                } else {
                    view.setBackgroundColor(colorBgGray);
                    view.setElevation(1);
                    mNumberOfPersons++;
                    mPersonsToArchive.add(person);
                    iMainFragmentLongClickMenu.onLongClicked(true, mPersonsToArchive);
                }
            } else {
                iMainFragmentLongClickMenu.onLongClicked(false, mPersonsToArchive);
            }
        }
    }

    private void setCardBackgroundByCategory(View view, Person person) {
        if (person.getCategory() == 0) {
            view.setBackgroundColor(ContextCompat.getColor(mContext, R.color.colorSure));
        } else if (person.getCategory() == 1) {
            view.setBackgroundColor(
                    ContextCompat.getColor(mContext, R.color.colorAlmostSure));
        } else if (person.getCategory() == 2) {
            view.setBackgroundColor(ContextCompat.getColor(mContext, R.color.colorUnsure));
        }
    }

    public void search(String newText) {
        if (newText.equals("roez")) {
            return;
        }
        if (!newText.isEmpty()) {
            Log.d(TAG, "text="+newText);
            for (Person p : mPersons) {
                Log.d(TAG, "person="+p.getName());
                int pos = mPersonsFiltered.indexOf(p);
                Log.d(TAG, "position="+pos);
                if (!p.getName().trim().toLowerCase().contains(newText.trim().toLowerCase())) {
                    if (pos != -1) {
                        Log.d(TAG, "person not matching but in list="+p.getName());
                        mPersonsFiltered.remove(pos);
                        notifyItemRemoved(pos);
                    }
                } else {
                    if (pos == -1) {
                        Log.d(TAG, "person matching but not in list="+p.getName());
                        mPersonsFiltered.add(p);
                        Log.d(TAG, "pre sorting");
                        //Collections.sort(mPersonsFiltered);
                        notifyItemInserted(pos);
                    }
                }
            }
        } else {
            Log.d(TAG, "search text empty");
            mPersonsFiltered = new ArrayList<>(mPersons);
            notifyDataSetChanged();
        }
    }

    public interface IMainListAdapter {
        void onInstanceCreated(int numberOfItems);
    }

    public interface IMainFragmentLongClickMenu {
        void onLongClicked(boolean isActive, List<Person> personsToArchive);
    }
}
