package de.davidartmann.rosa.adapter;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;

import java.util.ArrayList;
import java.util.List;

import de.davidartmann.rosa.db.async.FindAllActivePersonsFromDb;
import de.davidartmann.rosa.fragment.DetailFragment;
import de.davidartmann.rosa.model.Person;

/**
 * ViewPager adapter class.
 * Created by david on 03.03.16.
 */
public class ViewPagerAdapter extends FragmentStatePagerAdapter
        implements FindAllActivePersonsFromDb.IFindAllActive {

    private List<Person> persons;
    private ViewPager viewPager;
    private Person person;
    private IViewPagerAdapter iViewPagerAdapter;

    public ViewPagerAdapter(FragmentManager fm, Context context, ViewPager viewPager,
                            Person person, IViewPagerAdapter iViewPagerAdapter) {
        super(fm);
        persons = new ArrayList<>();
        this.viewPager = viewPager;
        this.person = person;
        this.iViewPagerAdapter = iViewPagerAdapter;
        new FindAllActivePersonsFromDb(context, this).execute();
    }

    @Override
    public Fragment getItem(int position) {
        return DetailFragment.newInstance(persons.get(position));
    }

    @Override
    public int getCount() {
        return persons.size();
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return persons.get(position).getName();
    }

    @Override
    public void onFindAllActive(List<Person> persons) {
        if (this.persons != null) {
            this.persons.clear();
            this.persons.addAll(persons);
        } else {
            this.persons = persons;
        }
        notifyDataSetChanged();
        viewPager.setCurrentItem(person.getPosition()-1);
        iViewPagerAdapter.onLoaded();
    }

    public interface IViewPagerAdapter {
        void onLoaded();
    }
}
