package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;
import de.davidartmann.rosa.util.PreferencesHelper;

/**
 * AsyncTask to store a Person to the DB.
 * Created by david on 03.03.16.
 */
public class CreateOrUpdatePerson extends AsyncTask<Person, Integer, Person> {

    private Context context;
    private PersonDao personDao;
    private boolean isUpdate;

    public CreateOrUpdatePerson(Context context, boolean isUpdate) {
        this.context = context;
        this.isUpdate = isUpdate;
    }

    @Override
    protected Person doInBackground(Person... persons) {
        personDao = new PersonDao(context);
        personDao.openWritable();
        if (isUpdate) {
            return personDao.update(persons[0]);
        } else {
            return personDao.create(persons[0]);

        }
    }

    @Override
    protected void onPostExecute(Person person) {
        super.onPostExecute(person);
        personDao.close();
    }
}
