package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask for loading all Persons which are active.
 * Created by david on 04.03.16.
 */
public class FindAllActivePersonsFromDb extends AsyncTask<String, Integer, List<Person>> {

    private Context context;
    private IFindAllActive iFindAllActive;
    private PersonDao personDao;

    public FindAllActivePersonsFromDb(Context context, IFindAllActive iFindAllActive) {
        this.context = context;
        this.iFindAllActive = iFindAllActive;
    }

    @Override
    protected List<Person> doInBackground(String... params) {
        personDao = new PersonDao(context);
        personDao.openReadable();
        return personDao.findAllActive();
    }

    @Override
    protected void onProgressUpdate(Integer... values) {
        super.onProgressUpdate(values);
    }

    @Override
    protected void onPostExecute(List<Person> persons) {
        super.onPostExecute(persons);
        iFindAllActive.onFindAllActive(persons);
        personDao.close();

    }

    public interface IFindAllActive {
        void onFindAllActive(List<Person> persons);
    }
}
