package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask for incrementing the position of all persons which follow the newly inserted person
 * when its position is changed.
 * Created by david on 05.03.16.
 */
public class IncrementPositionOfPersonsFromDb extends AsyncTask<String, Integer, List<Person>> {

    private IIncrementPosition iIncrementPosition;
    private List<Person> mPersons;
    private int mOldPos;
    private int mNewPos;
    private PersonDao personDao;
    private Context mContext;

    public IncrementPositionOfPersonsFromDb(Context context,
                                            IIncrementPosition iIncrementPosition,
                                            List<Person> persons,
                                            int oldPos, int newPos) {
        this.iIncrementPosition = iIncrementPosition;
        mPersons = persons;
        mOldPos = oldPos;
        mContext = context;
        mNewPos = newPos;
    }

    @Override
    protected List<Person> doInBackground(String... params) {
        personDao = new PersonDao(mContext);
        personDao.openWritable();
        if (mNewPos < mOldPos) {
            for (int i = 0; i < mPersons.size(); i++) {
                Person p = mPersons.get(i);
                if (p.getPosition() < mOldPos && p.getPosition() >= mNewPos) {
                    p.setPosition(p.getPosition() + 1);
                    mPersons.set(i, personDao.update(p));
                }
            }
        } else {
            for (int i = 0; i < mPersons.size(); i++) {
                Person p = mPersons.get(i);
                if (p.getPosition() > mOldPos && p.getPosition() <= mNewPos) {
                    p.setPosition(p.getPosition() - 1);
                    mPersons.set(i, personDao.update(p));
                }
            }
        }
        return mPersons;
    }

    @Override
    protected void onPostExecute(List<Person> persons) {
        super.onPostExecute(persons);
        iIncrementPosition.onIncremented(persons);
        personDao.close();

    }

    public interface IIncrementPosition {
        void onIncremented(List<Person> persons);
    }
}
