package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import java.util.ArrayList;
import java.util.List;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to soft delete several Persons in the DB.
 * This process is the soft deletion of a person (active = 0).
 * Created by david on 04.03.16.
 */
public class SoftDeletePersonsInDb extends AsyncTask<Void, Integer, Void> {

    private Context mContext;
    private PersonDao personDao;
    private ISoftDeletePersons iSoftDeletePersons;
    private List<Person> mPersonsToSoftDelete;
    private List<Person> mSoftDeletedPersons;

    public SoftDeletePersonsInDb(Context context, ISoftDeletePersons iSoftDeletePersons, List<Person> personsToSoftDelete) {
        mContext = context;
        this.iSoftDeletePersons = iSoftDeletePersons;
        mPersonsToSoftDelete = personsToSoftDelete;
        mSoftDeletedPersons = new ArrayList<>();
    }

    @Override
    protected Void doInBackground(Void... params) {
        personDao = new PersonDao(mContext);
        personDao.openWritable();
        for (Person p : mPersonsToSoftDelete) {
            mSoftDeletedPersons.add(personDao.softDelete(p));
        }
        return null;
    }

    @Override
    protected void onPostExecute(Void aVoid) {
        super.onPostExecute(aVoid);
        iSoftDeletePersons.onSoftDeleted(mSoftDeletedPersons);
        personDao.close();
    }

    public interface ISoftDeletePersons {
        void onSoftDeleted(List<Person> softDeletedPersons);
    }
}
