package de.davidartmann.rosa.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import de.davidartmann.rosa.R;

/**
 * Helper class for accessing the SharedPreferences.
 * Created by david on 04.03.16.
 */
public class PreferencesHelper {

    public static void decrementNextFreePosition(Context context) {
        SharedPreferences sharedPreferences =
                PreferenceManager.getDefaultSharedPreferences(context);
        int oldPos = sharedPreferences.getInt(
                context.getString(R.string.PREF_next_free_position), 1);
        if (oldPos >= 1) {
            sharedPreferences.edit().putInt(
                    context.getString(R.string.PREF_next_free_position), oldPos-1).apply();
        }
    }

    public static int getNextFreePosition(Context context) {
        SharedPreferences sharedPreferences =
                PreferenceManager.getDefaultSharedPreferences(context);
        return sharedPreferences.getInt(
                context.getString(R.string.PREF_next_free_position), 1);
    }

    public static void incrementNextFreePosition(Context context, int id) {
        SharedPreferences sharedPreferences =
                PreferenceManager.getDefaultSharedPreferences(context);
        sharedPreferences.edit().putInt(context.getString(R.string.PREF_next_free_position),
                (int) (id+1)).apply();
    }
}
