package de.davidartmann.rosa.util.crop;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import de.davidartmann.rosa.R;
import de.davidartmann.rosa.util.crop.CropOption;

/**
 * Adapter class for the CropOptions.
 * Created by david on 09.03.16.
 */
public class CropOptionAdapter extends ArrayAdapter<CropOption> {

    private List<CropOption> mCropOptions;
    private LayoutInflater mLayoutInflater;

    public CropOptionAdapter(Context context, List<CropOption> options) {
        super(context, R.layout.crop_selector, options);
        mCropOptions = options;
        mLayoutInflater = LayoutInflater.from(context);
    }

    @SuppressLint("InflateParams")
    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = mLayoutInflater.inflate(R.layout.crop_selector, null);
        }
        CropOption item = mCropOptions.get(position);
        if (item != null) {
            ((ImageView) convertView.findViewById(R.id.crop_selector_image))
                    .setImageDrawable(item.getIcon());
            ((TextView) convertView.findViewById(R.id.crop_selector_text)).setText(item.getTitle());
            return convertView;
        }
        return super.getView(position, convertView, parent);
    }
}
