/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.junit3;

import android.support.test.internal.runner.junit3.AndroidTestSuite;
import android.support.test.internal.runner.junit3.JUnit38ClassRunner;
import android.support.test.internal.runner.junit3.NonExecutingTestSuite;
import android.support.test.internal.util.AndroidRunnerBuilderUtil;
import android.support.test.internal.util.AndroidRunnerParams;
import android.util.Log;
import junit.framework.Test;
import org.junit.internal.builders.JUnit3Builder;
import org.junit.runner.Runner;

public class AndroidJUnit3Builder
extends JUnit3Builder {
    private static final String LOG_TAG = "AndroidJUnit3Builder";
    private final AndroidRunnerParams mAndroidRunnerParams;

    public AndroidJUnit3Builder(AndroidRunnerParams runnerParams) {
        this.mAndroidRunnerParams = runnerParams;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        try {
            if (AndroidRunnerBuilderUtil.isJUnit3Test(testClass)) {
                if (this.mAndroidRunnerParams.isSkipExecution()) {
                    return new JUnit38ClassRunner((Test)new NonExecutingTestSuite(testClass));
                }
                return new JUnit38ClassRunner((Test)new AndroidTestSuite(testClass, this.mAndroidRunnerParams));
            }
        }
        catch (Throwable e) {
            Log.e((String)LOG_TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
        return null;
    }
}

