/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.listener;

import android.support.test.internal.runner.TestSize;
import android.support.test.internal.runner.listener.InstrumentationRunListener;
import android.util.Log;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class SuiteAssignmentPrinter
extends InstrumentationRunListener {
    long mStartTime;
    long mEndTime;
    boolean mTimingValid;

    public void testStarted(Description description) throws Exception {
        this.mTimingValid = true;
        this.mStartTime = this.getCurrentTimeMillis();
    }

    public void testFinished(Description description) throws Exception {
        this.mEndTime = this.getCurrentTimeMillis();
        if (!this.mTimingValid || this.mStartTime < 0L) {
            this.sendString("F");
            Log.d((String)"SuiteAssignmentPrinter", (String)String.format("%s#%s: skipping suite assignment due to test failure\n", description.getClassName(), description.getMethodName()));
        } else {
            TestSize currentRenameSize;
            long runTime = this.mEndTime - this.mStartTime;
            TestSize assignmentSuite = TestSize.getTestSizeForRunTime(runTime);
            if (!assignmentSuite.equals(currentRenameSize = TestSize.fromDescription(description))) {
                this.sendString(String.format("\n%s#%s: current size: %s. suggested: %s runTime: %d ms\n", description.getClassName(), description.getMethodName(), currentRenameSize, assignmentSuite.getSizeQualifierName(), runTime));
            } else {
                this.sendString(".");
                Log.d((String)"SuiteAssignmentPrinter", (String)String.format("%s#%s assigned correctly as %s. runTime: %d ms\n", description.getClassName(), description.getMethodName(), assignmentSuite.getSizeQualifierName(), runTime));
            }
        }
        this.mStartTime = -1L;
    }

    public void testFailure(Failure failure) throws Exception {
        this.mTimingValid = false;
    }

    public void testAssumptionFailure(Failure failure) {
        this.mTimingValid = false;
    }

    public void testIgnored(Description description) throws Exception {
        this.mTimingValid = false;
    }

    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

