/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.Box;
import org.jcodec.ClearApertureBox;
import org.jcodec.DataInfoBox;
import org.jcodec.DataRefBox;
import org.jcodec.Edit;
import org.jcodec.EditListBox;
import org.jcodec.EncodedPixelBox;
import org.jcodec.GenericMediaInfoBox;
import org.jcodec.Header;
import org.jcodec.LeafBox;
import org.jcodec.MediaInfoBox;
import org.jcodec.MovieHeaderBox;
import org.jcodec.NameBox;
import org.jcodec.NodeBox;
import org.jcodec.PixelAspectExt;
import org.jcodec.ProductionApertureBox;
import org.jcodec.Rational;
import org.jcodec.SampleEntry;
import org.jcodec.SampleToChunkBox;
import org.jcodec.Size;
import org.jcodec.SoundMediaHeaderBox;
import org.jcodec.TimecodeMediaInfoBox;
import org.jcodec.TrackType;
import org.jcodec.TrakBox;
import org.jcodec.Unit;
import org.jcodec.VideoMediaHeaderBox;
import org.jcodec.VideoSampleEntry;

public abstract class AbstractMP4MuxerTrack {
    protected int trackId;
    protected TrackType type;
    protected int timescale;
    protected Rational tgtChunkDuration;
    protected Unit tgtChunkDurationUnit;
    protected long chunkDuration;
    protected List<ByteBuffer> curChunk = new ArrayList<ByteBuffer>();
    protected List<SampleToChunkBox.SampleToChunkEntry> samplesInChunks = new ArrayList<SampleToChunkBox.SampleToChunkEntry>();
    protected int samplesInLastChunk = -1;
    protected int chunkNo = 0;
    protected boolean finished;
    protected List<SampleEntry> sampleEntries = new ArrayList<SampleEntry>();
    protected List<Edit> edits;
    private String name;

    public AbstractMP4MuxerTrack(int trackId, TrackType type, int timescale) {
        this.trackId = trackId;
        this.type = type;
        this.timescale = timescale;
    }

    public void setTgtChunkDuration(Rational duration, Unit unit) {
        this.tgtChunkDuration = duration;
        this.tgtChunkDurationUnit = unit;
    }

    public abstract long getTrackTotalDuration();

    public int getTimescale() {
        return this.timescale;
    }

    protected abstract Box finish(MovieHeaderBox var1) throws IOException;

    public boolean isVideo() {
        return this.type == TrackType.VIDEO;
    }

    public boolean isTimecode() {
        return this.type == TrackType.TIMECODE;
    }

    public boolean isAudio() {
        return this.type == TrackType.SOUND;
    }

    public Size getDisplayDimensions() {
        int width = 0;
        int height = 0;
        if (this.sampleEntries.get(0) instanceof VideoSampleEntry) {
            VideoSampleEntry vse = (VideoSampleEntry)this.sampleEntries.get(0);
            PixelAspectExt paspBox = Box.findFirst((NodeBox)vse, PixelAspectExt.class, PixelAspectExt.fourcc());
            Rational pasp = paspBox != null ? paspBox.getRational() : new Rational(1, 1);
            width = pasp.getNum() * vse.getWidth() / pasp.getDen();
            height = vse.getHeight();
        }
        return new Size(width, height);
    }

    public void tapt(TrakBox trak) {
        Size dd2 = this.getDisplayDimensions();
        if (this.type == TrackType.VIDEO) {
            NodeBox tapt = new NodeBox(new Header("tapt"));
            tapt.add(new ClearApertureBox(dd2.getWidth(), dd2.getHeight()));
            tapt.add(new ProductionApertureBox(dd2.getWidth(), dd2.getHeight()));
            tapt.add(new EncodedPixelBox(dd2.getWidth(), dd2.getHeight()));
            trak.add(tapt);
        }
    }

    public void addSampleEntry(SampleEntry se2) {
        if (this.finished) {
            throw new IllegalStateException("The muxer track has finished muxing");
        }
        this.sampleEntries.add(se2);
    }

    public List<SampleEntry> getEntries() {
        return this.sampleEntries;
    }

    public void setEdits(List<Edit> edits) {
        this.edits = edits;
    }

    protected void putEdits(TrakBox trak) {
        if (this.edits != null) {
            NodeBox edts = new NodeBox(new Header("edts"));
            edts.add(new EditListBox(this.edits));
            trak.add(edts);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void putName(TrakBox trak) {
        if (this.name != null) {
            NodeBox udta = new NodeBox(new Header("udta"));
            udta.add(new NameBox(this.name));
            trak.add(udta);
        }
    }

    protected void mediaHeader(MediaInfoBox minf, TrackType type) {
        switch (type) {
            case VIDEO: {
                VideoMediaHeaderBox vmhd = new VideoMediaHeaderBox(0, 0, 0, 0);
                vmhd.setFlags(1);
                minf.add(vmhd);
                break;
            }
            case SOUND: {
                SoundMediaHeaderBox smhd = new SoundMediaHeaderBox();
                smhd.setFlags(1);
                minf.add(smhd);
                break;
            }
            case TIMECODE: {
                NodeBox gmhd = new NodeBox(new Header("gmhd"));
                gmhd.add(new GenericMediaInfoBox());
                NodeBox tmcd = new NodeBox(new Header("tmcd"));
                gmhd.add(tmcd);
                tmcd.add(new TimecodeMediaInfoBox(0, 0, 12, new short[]{0, 0, 0}, new short[]{255, 255, 255}, "Lucida Grande"));
                minf.add(gmhd);
                break;
            }
            default: {
                throw new IllegalStateException("Handler " + type.getHandler() + " not supported");
            }
        }
    }

    protected void addDref(NodeBox minf) {
        DataInfoBox dinf = new DataInfoBox();
        minf.add(dinf);
        DataRefBox dref = new DataRefBox();
        dinf.add(dref);
        dref.add(new LeafBox(new Header("alis", 0L), ByteBuffer.wrap(new byte[]{0, 0, 0, 1})));
    }
}

