/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

public class AudioFormat {
    private int sampleRate;
    private int sampleSizeInBits;
    private int channelCount;
    private boolean signed;
    private boolean bigEndian;

    public AudioFormat(int sampleRate, int sampleSizeInBits, int channelCount, boolean signed, boolean bigEndian) {
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channelCount = channelCount;
        this.signed = signed;
        this.bigEndian = bigEndian;
    }

    public int getChannels() {
        return this.channelCount;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public short getFrameSize() {
        return (short)((this.sampleSizeInBits >> 3) * this.channelCount);
    }

    public int getFrameRate() {
        return this.sampleRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isSigned() {
        return this.signed;
    }
}

