/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jcodec.Box;
import org.jcodec.BoxFactory;
import org.jcodec.ChannelBox;
import org.jcodec.Header;
import org.jcodec.LeafBox;
import org.jcodec.SampleEntry;
import org.jcodec.ToJSON;
import org.jcodec.WaveExtension;

public class AudioSampleEntry
extends SampleEntry {
    private static final MyFactory FACTORY = new MyFactory();
    private short channelCount;
    private short sampleSize;
    private float sampleRate;
    private short revision;
    private int vendor;
    private int compressionId;
    private int pktSize;
    private int samplesPerPkt;
    private int bytesPerPkt;
    private int bytesPerFrame;
    private int bytesPerSample;
    private short version;
    private int lpcmFlags;
    public static Set<String> pcms = new HashSet<String>();

    public AudioSampleEntry(Header atom) {
        super(atom);
        this.factory = FACTORY;
    }

    public AudioSampleEntry(Header header, short drefInd, short channelCount, short sampleSize, int sampleRate, short revision, int vendor, int compressionId, int pktSize, int samplesPerPkt, int bytesPerPkt, int bytesPerFrame, int bytesPerSample, short version) {
        super(header, drefInd);
        this.channelCount = channelCount;
        this.sampleSize = sampleSize;
        this.sampleRate = sampleRate;
        this.revision = revision;
        this.vendor = vendor;
        this.compressionId = compressionId;
        this.pktSize = pktSize;
        this.samplesPerPkt = samplesPerPkt;
        this.bytesPerPkt = bytesPerPkt;
        this.bytesPerFrame = bytesPerFrame;
        this.bytesPerSample = bytesPerSample;
        this.version = version;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.version = input.getShort();
        this.revision = input.getShort();
        this.vendor = input.getInt();
        this.channelCount = input.getShort();
        this.sampleSize = input.getShort();
        this.compressionId = input.getShort();
        this.pktSize = input.getShort();
        long sr = (long)input.getInt() & 0xFFFFFFFFL;
        this.sampleRate = (float)sr / 65536.0f;
        if (this.version == 1) {
            this.samplesPerPkt = input.getInt();
            this.bytesPerPkt = input.getInt();
            this.bytesPerFrame = input.getInt();
            this.bytesPerSample = input.getInt();
        } else if (this.version == 2) {
            input.getInt();
            this.sampleRate = (float)Double.longBitsToDouble(input.getLong());
            this.channelCount = (short)input.getInt();
            input.getInt();
            this.sampleSize = (short)input.getInt();
            this.lpcmFlags = input.getInt();
            this.bytesPerFrame = input.getInt();
            this.samplesPerPkt = input.getInt();
        }
        this.parseExtensions(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putShort(this.version);
        out.putShort(this.revision);
        out.putInt(this.vendor);
        if (this.version < 2) {
            out.putShort(this.channelCount);
            if (this.version == 0) {
                out.putShort(this.sampleSize);
            } else {
                out.putShort((short)16);
            }
            out.putShort((short)this.compressionId);
            out.putShort((short)this.pktSize);
            out.putInt((int)Math.round((double)this.sampleRate * 65536.0));
            if (this.version == 1) {
                out.putInt(this.samplesPerPkt);
                out.putInt(this.bytesPerPkt);
                out.putInt(this.bytesPerFrame);
                out.putInt(this.bytesPerSample);
                this.writeExtensions(out);
            }
        } else if (this.version == 2) {
            out.putShort((short)3);
            out.putShort((short)16);
            out.putShort((short)-2);
            out.putShort((short)0);
            out.putInt(65536);
            out.putInt(72);
            out.putLong(Double.doubleToLongBits(this.sampleRate));
            out.putInt(this.channelCount);
            out.putInt(0x7F000000);
            out.putInt(this.sampleSize);
            out.putInt(this.lpcmFlags);
            out.putInt(this.bytesPerFrame);
            out.putInt(this.samplesPerPkt);
            this.writeExtensions(out);
        }
    }

    public short getChannelCount() {
        return this.channelCount;
    }

    public int calcFrameSize() {
        if (this.version == 0 || this.bytesPerFrame == 0) {
            return (this.sampleSize >> 3) * this.channelCount;
        }
        return this.bytesPerFrame;
    }

    public int calcSampleSize() {
        return this.calcFrameSize() / this.channelCount;
    }

    public short getSampleSize() {
        return this.sampleSize;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getBytesPerFrame() {
        return this.bytesPerFrame;
    }

    public int getBytesPerSample() {
        return this.bytesPerSample;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isPCM() {
        return pcms.contains(this.header.getFourcc());
    }

    @Override
    public void dump(StringBuilder sb2) {
        sb2.append(this.header.getFourcc() + ": {\n");
        sb2.append("entry: ");
        ToJSON.toJSON(this, sb2, "channelCount", "sampleSize", "sampleRat", "revision", "vendor", "compressionId", "pktSize", "samplesPerPkt", "bytesPerPkt", "bytesPerFrame", "bytesPerSample", "version", "lpcmFlags");
        sb2.append(",\nexts: [\n");
        this.dumpBoxes(sb2);
        sb2.append("\n]\n");
        sb2.append("}\n");
    }

    static {
        pcms.add("raw ");
        pcms.add("twos");
        pcms.add("sowt");
        pcms.add("fl32");
        pcms.add("fl64");
        pcms.add("in24");
        pcms.add("in32");
        pcms.add("lpcm");
    }

    public static class MyFactory
    extends BoxFactory {
        private Map<String, Class<? extends Box>> mappings = new HashMap<String, Class<? extends Box>>();

        public MyFactory() {
            this.mappings.put(WaveExtension.fourcc(), WaveExtension.class);
            this.mappings.put(ChannelBox.fourcc(), ChannelBox.class);
            this.mappings.put("esds", LeafBox.class);
        }

        @Override
        public Class<? extends Box> toClass(String fourcc) {
            return this.mappings.get(fourcc);
        }
    }
}

