/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.jcodec.Box;
import org.jcodec.Header;
import org.jcodec.NIOUtils;

public class AvcCBox
extends Box {
    private int profile;
    private int profileCompat;
    private int level;
    private List<ByteBuffer> spsList = new ArrayList<ByteBuffer>();
    private List<ByteBuffer> ppsList = new ArrayList<ByteBuffer>();
    private int nalLengthSize;

    public AvcCBox(Box other) {
        super(other);
    }

    public AvcCBox() {
        super(new Header(AvcCBox.fourcc()));
    }

    public AvcCBox(Header header) {
        super(header);
    }

    public AvcCBox(int profile, int profileCompat, int level, List<ByteBuffer> spsList, List<ByteBuffer> ppsList) {
        this();
        this.profile = profile;
        this.profileCompat = profileCompat;
        this.level = level;
        this.spsList = spsList;
        this.ppsList = ppsList;
    }

    public static String fourcc() {
        return "avcC";
    }

    @Override
    public void parse(ByteBuffer input) {
        NIOUtils.skip(input, 1);
        this.profile = input.get() & 0xFF;
        this.profileCompat = input.get() & 0xFF;
        this.level = input.get() & 0xFF;
        int flags = input.get() & 0xFF;
        this.nalLengthSize = (flags & 3) + 1;
        int nSPS = input.get() & 0x1F;
        for (int i2 = 0; i2 < nSPS; ++i2) {
            short spsSize = input.getShort();
            Assert.assertEquals((int)39, (int)(input.get() & 0x3F));
            this.spsList.add(NIOUtils.read(input, spsSize - 1));
        }
        int nPPS = input.get() & 0xFF;
        for (int i3 = 0; i3 < nPPS; ++i3) {
            short ppsSize = input.getShort();
            Assert.assertEquals((int)40, (int)(input.get() & 0x3F));
            this.ppsList.add(NIOUtils.read(input, ppsSize - 1));
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.put((byte)1);
        out.put((byte)this.profile);
        out.put((byte)this.profileCompat);
        out.put((byte)this.level);
        out.put((byte)-1);
        out.put((byte)(this.spsList.size() | 0xE0));
        for (ByteBuffer sps : this.spsList) {
            out.putShort((short)(sps.remaining() + 1));
            out.put((byte)103);
            NIOUtils.write(out, sps);
        }
        out.put((byte)this.ppsList.size());
        for (ByteBuffer pps : this.ppsList) {
            out.putShort((byte)(pps.remaining() + 1));
            out.put((byte)104);
            NIOUtils.write(out, pps);
        }
    }

    public List<ByteBuffer> getSpsList() {
        return this.spsList;
    }

    public List<ByteBuffer> getPpsList() {
        return this.ppsList;
    }

    public int getNalLengthSize() {
        return this.nalLengthSize;
    }
}

