/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import org.jcodec.BitWriter;
import org.jcodec.Debug;
import org.jcodec.MathUtil;

public class CAVLCWriter {
    private CAVLCWriter() {
    }

    public static void writeUE(BitWriter out, int value) {
        int bits = 0;
        int cumul = 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            if (value < cumul + (1 << i2)) {
                bits = i2;
                break;
            }
            cumul += 1 << i2;
        }
        out.writeNBit(0, bits);
        out.write1Bit(1);
        out.writeNBit(value - cumul, bits);
    }

    public static void writeSE(BitWriter out, int value) {
        CAVLCWriter.writeUE(out, MathUtil.golomb(value));
    }

    public static void writeUE(BitWriter out, int value, String message) {
        CAVLCWriter.writeUE(out, value);
        Debug.trace(message, value);
    }

    public static void writeSE(BitWriter out, int value, String message) {
        CAVLCWriter.writeUE(out, MathUtil.golomb(value));
        Debug.trace(message, value);
    }

    public static void writeBool(BitWriter out, boolean value, String message) {
        out.write1Bit(value ? 1 : 0);
        Debug.trace(message, value ? 1 : 0);
    }

    public static void writeU(BitWriter out, int i2, int n2) {
        out.writeNBit(i2, n2);
    }

    public static void writeNBit(BitWriter out, long value, int n2, String message) {
        for (int i2 = 0; i2 < n2; ++i2) {
            out.write1Bit((int)(value >> n2 - i2 - 1) & 1);
        }
        Debug.trace(message, value);
    }

    public static void writeTrailingBits(BitWriter out) {
        out.write1Bit(1);
        out.flush();
    }

    public static void writeSliceTrailingBits() {
        throw new IllegalStateException("todo");
    }
}

