/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.Box;
import org.jcodec.Header;

public class ClipRegionBox
extends Box {
    private short rgnSize;
    private short y;
    private short x;
    private short height;
    private short width;

    public static String fourcc() {
        return "crgn";
    }

    public ClipRegionBox(Header atom) {
        super(atom);
    }

    public ClipRegionBox() {
        super(new Header(ClipRegionBox.fourcc()));
    }

    public ClipRegionBox(short x2, short y2, short width, short height) {
        this();
        this.rgnSize = (short)10;
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
    }

    @Override
    public void parse(ByteBuffer input) {
        this.rgnSize = input.getShort();
        this.y = input.getShort();
        this.x = input.getShort();
        this.height = input.getShort();
        this.width = input.getShort();
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.putShort(this.rgnSize);
        out.putShort(this.y);
        out.putShort(this.x);
        out.putShort(this.height);
        out.putShort(this.width);
    }

    public short getRgnSize() {
        return this.rgnSize;
    }

    public short getY() {
        return this.y;
    }

    public short getX() {
        return this.x;
    }

    public short getHeight() {
        return this.height;
    }

    public short getWidth() {
        return this.width;
    }
}

