/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.Edit;
import org.jcodec.FullBox;
import org.jcodec.Header;
import org.jcodec.ToJSON;

public class EditListBox
extends FullBox {
    private List<Edit> edits;

    public static String fourcc() {
        return "elst";
    }

    public EditListBox(Header atom) {
        super(atom);
    }

    public EditListBox() {
        this(new Header(EditListBox.fourcc()));
    }

    public EditListBox(List<Edit> edits) {
        this();
        this.edits = edits;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.edits = new ArrayList<Edit>();
        long num = input.getInt();
        int i2 = 0;
        while ((long)i2 < num) {
            int duration = input.getInt();
            int mediaTime = input.getInt();
            float rate = (float)input.getInt() / 65536.0f;
            this.edits.add(new Edit(duration, mediaTime, rate));
            ++i2;
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.edits.size());
        for (Edit edit : this.edits) {
            out.putInt((int)edit.getDuration());
            out.putInt((int)edit.getMediaTime());
            out.putInt((int)(edit.getRate() * 65536.0f));
        }
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    @Override
    protected void dump(StringBuilder sb2) {
        super.dump(sb2);
        sb2.append(": ");
        ToJSON.toJSON(this, sb2, "edits");
    }
}

