/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;

public class JCodecUtil {
    public static byte[] asciiString(String fourcc) {
        char[] ch = fourcc.toCharArray();
        byte[] result = new byte[ch.length];
        for (int i2 = 0; i2 < ch.length; ++i2) {
            result[i2] = (byte)ch[i2];
        }
        return result;
    }

    public static void writeBER32(ByteBuffer buffer, int value) {
        buffer.put((byte)(value >> 21 | 0x80));
        buffer.put((byte)(value >> 14 | 0x80));
        buffer.put((byte)(value >> 7 | 0x80));
        buffer.put((byte)(value & 0x7F));
    }

    public static int readBER32(ByteBuffer input) {
        int size = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte b2 = input.get();
            size = size << 7 | b2 & 0x7F;
            if ((b2 & 0xFF) >> 7 == 0) break;
        }
        return size;
    }

    public static int[] getAsIntArray(ByteBuffer yuv, int size) {
        byte[] b2 = new byte[size];
        int[] result = new int[size];
        yuv.get(b2);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            result[i2] = b2[i2] & 0xFF;
        }
        return result;
    }

    public static String removeExtension(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("\\.[^\\.]+$", "");
    }

    public static enum Format {
        MOV,
        MPEG_PS,
        MPEG_TS;

    }
}

