/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.util.Arrays;

public class LongArrayList {
    private static final int DEFAULT_GROW_AMOUNT = 128;
    private long[] storage;
    private int size;
    private int growAmount;

    public LongArrayList() {
        this(128);
    }

    public LongArrayList(int growAmount) {
        this.growAmount = growAmount;
        this.storage = new long[growAmount];
    }

    public long[] toArray() {
        long[] result = new long[this.size];
        System.arraycopy(this.storage, 0, result, 0, this.size);
        return result;
    }

    public void add(long val) {
        if (this.size >= this.storage.length) {
            long[] ns = new long[this.storage.length + this.growAmount];
            System.arraycopy(this.storage, 0, ns, 0, this.storage.length);
            this.storage = ns;
        }
        this.storage[this.size++] = val;
    }

    public void set(int index, int value) {
        this.storage[index] = value;
    }

    public long get(int index) {
        return this.storage[index];
    }

    public void fill(int start, int end, int val) {
        if (end > this.storage.length) {
            long[] ns = new long[end + this.growAmount];
            System.arraycopy(this.storage, 0, ns, 0, this.storage.length);
            this.storage = ns;
        }
        Arrays.fill(this.storage, start, end, (long)val);
        this.size = Math.max(this.size, end);
    }

    public int size() {
        return this.size;
    }

    public void addAll(long[] other) {
        if (this.size + other.length >= this.storage.length) {
            long[] ns = new long[this.size + this.growAmount + other.length];
            System.arraycopy(this.storage, 0, ns, 0, this.size);
            this.storage = ns;
        }
        System.arraycopy(other, 0, this.storage, this.size, other.length);
        this.size += other.length;
    }
}

