/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodec.Codec;
import org.jcodec.Header;
import org.jcodec.MovieBox;
import org.jcodec.NIOUtils;
import org.jcodec.SeekableByteChannel;

public class MP4Util {
    private static final int MIN_HEADER_SIZE = 256000;
    private static Map<Codec, String> codecMapping = new HashMap<Codec, String>();

    public static List<Atom> getRootAtoms(SeekableByteChannel input) throws IOException {
        Header atom;
        input.position(0L);
        ArrayList<Atom> result = new ArrayList<Atom>();
        for (long off = 0L; off < input.size(); off += atom.getSize()) {
            input.position(off);
            atom = Header.read(NIOUtils.fetchFrom(input, 16));
            if (atom == null) break;
            result.add(new Atom(atom, off));
        }
        return result;
    }

    public static void writeMovie(File f2, MovieBox movie) throws IOException {
        AbstractInterruptibleChannel out = null;
        try {
            out = new FileInputStream(f2).getChannel();
            MP4Util.writeMovie(f2, movie);
        }
        finally {
            out.close();
        }
    }

    public static void writeMovieOnRAM(SeekableByteChannel out, MovieBox movie) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(0x1000000);
        movie.write(buf);
        buf.flip();
        out.write(buf);
    }

    public static void writeMovieOnFile(SeekableByteChannel out, MovieBox movie) throws IOException {
        long lastPos = out.position();
        out.close();
        RandomAccessFile raf = new RandomAccessFile(out.getFileName(), "rws");
        raf.setLength(Math.max(out.getWantedSize() * 2L, 256000L));
        MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, raf.length());
        buf.position((int)lastPos);
        movie.write(buf);
        int writePos = buf.position();
        FileChannel rafCh = raf.getChannel();
        rafCh.truncate(writePos);
        out.setChannel(rafCh);
    }

    public static String getFourcc(Codec codec) {
        return codecMapping.get((Object)codec);
    }

    static {
        codecMapping.put(Codec.MPEG2, "m2v1");
        codecMapping.put(Codec.H264, "avc1");
        codecMapping.put(Codec.J2K, "mjp2");
    }

    public static class Atom {
        private long offset;
        private Header header;

        public Atom(Header header, long offset) {
            this.header = header;
            this.offset = offset;
        }

        public long getOffset() {
            return this.offset;
        }

        public Header getHeader() {
            return this.header;
        }

        public void copy(SeekableByteChannel input, WritableByteChannel out) throws IOException {
            input.position(this.offset);
            NIOUtils.copy(input, out, this.header.getSize());
        }
    }
}

