/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.Box;
import org.jcodec.BoxFactory;
import org.jcodec.Header;
import org.jcodec.LeafBox;
import org.jcodec.MovieHeaderBox;
import org.jcodec.NIOUtils;

public class NodeBox
extends Box {
    private static final int MAX_BOX_SIZE = 0x8000000;
    protected List<Box> boxes = new LinkedList<Box>();
    protected BoxFactory factory = BoxFactory.getDefault();

    public NodeBox(Header atom) {
        super(atom);
    }

    public NodeBox(NodeBox other) {
        super(other);
        this.boxes = other.boxes;
        this.factory = other.factory;
    }

    @Override
    public void parse(ByteBuffer input) {
        while (input.remaining() >= 8) {
            Box child = NodeBox.parseChildBox(input, this.factory);
            if (child == null) continue;
            this.boxes.add(child);
        }
    }

    public static Box parseChildBox(ByteBuffer input, BoxFactory factory) {
        ByteBuffer fork = input.duplicate();
        while (input.remaining() >= 4 && fork.getInt() == 0) {
            input.getInt();
        }
        if (input.remaining() < 4) {
            return null;
        }
        Header childAtom = Header.read(input);
        if (childAtom != null && (long)input.remaining() >= childAtom.getBodySize()) {
            return NodeBox.parseBox(NIOUtils.read(input, (int)childAtom.getBodySize()), childAtom, factory);
        }
        return null;
    }

    public static Box newBox(Header header, BoxFactory factory) {
        Class<? extends Box> claz = factory.toClass(header.getFourcc());
        if (claz == null) {
            return new LeafBox(header);
        }
        try {
            try {
                return claz.getConstructor(Header.class).newInstance(header);
            }
            catch (NoSuchMethodException e2) {
                return claz.newInstance();
            }
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    public static Box parseBox(ByteBuffer input, Header childAtom, BoxFactory factory) {
        Box box = NodeBox.newBox(childAtom, factory);
        if (childAtom.getBodySize() < 0x8000000L) {
            box.parse(input);
            return box;
        }
        return new LeafBox(new Header("free", 8L));
    }

    public List<Box> getBoxes() {
        return this.boxes;
    }

    public void add(Box box) {
        this.boxes.add(box);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        for (Box box : this.boxes) {
            box.write(out);
        }
    }

    public void addFirst(MovieHeaderBox box) {
        this.boxes.add(0, box);
    }

    public void replace(String fourcc, Box box) {
        this.removeChildren(fourcc);
        this.add(box);
    }

    @Override
    public void dump(StringBuilder sb2) {
        super.dump(sb2);
        sb2.append(": {\n");
        this.dumpBoxes(sb2);
        sb2.append("\n}");
    }

    protected void dumpBoxes(StringBuilder sb2) {
        StringBuilder sb1 = new StringBuilder();
        Iterator<Box> iterator = this.boxes.iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(sb1);
            if (!iterator.hasNext()) continue;
            sb1.append(",\n");
        }
        sb2.append(sb1.toString().replaceAll("([^\n]*)\n", "  $1\n"));
    }

    public void removeChildren(String ... fourcc) {
        Iterator<Box> it = this.boxes.iterator();
        block0: while (it.hasNext()) {
            Box box = it.next();
            String fcc = box.getFourcc();
            for (String cand : fourcc) {
                if (!cand.equals(fcc)) continue;
                it.remove();
                continue block0;
            }
        }
    }
}

