/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import org.jcodec.FullBox;
import org.jcodec.Header;

public class SampleToChunkBox
extends FullBox {
    private SampleToChunkEntry[] sampleToChunk;

    public static String fourcc() {
        return "stsc";
    }

    public SampleToChunkBox(SampleToChunkEntry[] sampleToChunk) {
        super(new Header(SampleToChunkBox.fourcc()));
        this.sampleToChunk = sampleToChunk;
    }

    public SampleToChunkBox() {
        super(new Header(SampleToChunkBox.fourcc()));
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int size = input.getInt();
        this.sampleToChunk = new SampleToChunkEntry[size];
        for (int i2 = 0; i2 < size; ++i2) {
            this.sampleToChunk[i2] = new SampleToChunkEntry(input.getInt(), input.getInt(), input.getInt());
        }
    }

    public SampleToChunkEntry[] getSampleToChunk() {
        return this.sampleToChunk;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.sampleToChunk.length);
        for (SampleToChunkEntry stc : this.sampleToChunk) {
            out.putInt((int)stc.getFirst());
            out.putInt(stc.getCount());
            out.putInt(stc.getEntry());
        }
    }

    public void setSampleToChunk(SampleToChunkEntry[] sampleToChunk) {
        this.sampleToChunk = sampleToChunk;
    }

    public static class SampleToChunkEntry {
        private long first;
        private int count;
        private int entry;

        public SampleToChunkEntry(long first, int count, int entry) {
            this.first = first;
            this.count = count;
            this.entry = entry;
        }

        public long getFirst() {
            return this.first;
        }

        public void setFirst(long first) {
            this.first = first;
        }

        public int getCount() {
            return this.count;
        }

        public int getEntry() {
            return this.entry;
        }

        public void setEntry(int entry) {
            this.entry = entry;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

