/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.util.List;
import org.jcodec.Box;
import org.jcodec.ClearApertureBox;
import org.jcodec.ClipRegionBox;
import org.jcodec.DataInfoBox;
import org.jcodec.DataRefBox;
import org.jcodec.Edit;
import org.jcodec.EditListBox;
import org.jcodec.EncodedPixelBox;
import org.jcodec.FullBox;
import org.jcodec.HandlerBox;
import org.jcodec.Header;
import org.jcodec.MediaBox;
import org.jcodec.MediaHeaderBox;
import org.jcodec.MediaInfoBox;
import org.jcodec.NameBox;
import org.jcodec.NodeBox;
import org.jcodec.PixelAspectExt;
import org.jcodec.ProductionApertureBox;
import org.jcodec.Rational;
import org.jcodec.SampleEntry;
import org.jcodec.SampleSizesBox;
import org.jcodec.Size;
import org.jcodec.TimeToSampleBox;
import org.jcodec.TrackHeaderBox;
import org.jcodec.VideoSampleEntry;

public class TrakBox
extends NodeBox {
    public static String fourcc() {
        return "trak";
    }

    public TrakBox(Header atom) {
        super(atom);
    }

    public TrakBox() {
        super(new Header(TrakBox.fourcc()));
    }

    public MediaBox getMdia() {
        return TrakBox.findFirst((NodeBox)this, MediaBox.class, "mdia");
    }

    public TrackHeaderBox getTrackHeader() {
        return TrakBox.findFirst((NodeBox)this, TrackHeaderBox.class, "tkhd");
    }

    public List<Edit> getEdits() {
        EditListBox elst = TrakBox.findFirst((NodeBox)this, EditListBox.class, "edts", "elst");
        if (elst == null) {
            return null;
        }
        return elst.getEdits();
    }

    public boolean isVideo() {
        return "vide".equals(this.getHandlerType());
    }

    public boolean isTimecode() {
        return "tmcd".equals(this.getHandlerType());
    }

    public String getHandlerType() {
        HandlerBox handlerBox = TrakBox.findFirst((NodeBox)this, HandlerBox.class, "mdia", "hdlr");
        if (handlerBox == null) {
            return null;
        }
        String type = handlerBox.getComponentSubType();
        return type;
    }

    public boolean isAudio() {
        return "soun".equals(this.getHandlerType());
    }

    public int getTimescale() {
        return TrakBox.findFirst((NodeBox)this, MediaHeaderBox.class, "mdia", "mdhd").getTimescale();
    }

    public long rescale(long tv, long ts) {
        return tv * (long)this.getTimescale() / ts;
    }

    public void setDuration(long duration) {
        this.getTrackHeader().setDuration(duration);
    }

    public long getDuration() {
        return this.getTrackHeader().getDuration();
    }

    public long getMediaDuration() {
        return TrakBox.findFirst((NodeBox)this, MediaHeaderBox.class, "mdia", "mdhd").getDuration();
    }

    public boolean isPureRef() {
        MediaInfoBox minf = this.getMdia().getMinf();
        DataInfoBox dinf = minf.getDinf();
        if (dinf == null) {
            return false;
        }
        DataRefBox dref = dinf.getDref();
        if (dref == null) {
            return false;
        }
        for (Box box : dref.boxes) {
            if ((((FullBox)box).getFlags() & 1) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasDataRef() {
        DataInfoBox dinf = this.getMdia().getMinf().getDinf();
        if (dinf == null) {
            return false;
        }
        DataRefBox dref = dinf.getDref();
        if (dref == null) {
            return false;
        }
        boolean result = false;
        for (Box box : dref.boxes) {
            result |= (((FullBox)box).getFlags() & 1) != 1;
        }
        return result;
    }

    public Rational getPAR() {
        PixelAspectExt pasp = NodeBox.findFirst((NodeBox)this, PixelAspectExt.class, "mdia", "minf", "stbl", "stsd", null, "pasp");
        return pasp == null ? new Rational(1, 1) : pasp.getRational();
    }

    public SampleEntry[] getSampleEntries() {
        return NodeBox.findAll((Box)this, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null);
    }

    public void setClipRect(short x2, short y2, short width, short height) {
        NodeBox clip = NodeBox.findFirst((NodeBox)this, NodeBox.class, "clip");
        if (clip == null) {
            clip = new NodeBox(new Header("clip"));
            this.add(clip);
        }
        clip.replace("crgn", new ClipRegionBox(x2, y2, width, height));
    }

    public long getSampleCount() {
        return NodeBox.findFirst((NodeBox)this, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz").getCount();
    }

    public void setAperture(Size sar, Size dar) {
        this.removeChildren("tapt");
        NodeBox tapt = new NodeBox(new Header("tapt"));
        tapt.add(new ClearApertureBox(dar.getWidth(), dar.getHeight()));
        tapt.add(new ProductionApertureBox(dar.getWidth(), dar.getHeight()));
        tapt.add(new EncodedPixelBox(sar.getWidth(), sar.getHeight()));
        this.add(tapt);
    }

    public void setDimensions(Size dd2) {
        this.getTrackHeader().setWidth(dd2.getWidth());
        this.getTrackHeader().setHeight(dd2.getHeight());
    }

    public int getFrameCount() {
        SampleSizesBox stsz = TrakBox.findFirst((NodeBox)this, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        return stsz.getDefaultSize() != 0 ? stsz.getCount() : stsz.getSizes().length;
    }

    public String getName() {
        NameBox nb2 = Box.findFirst((NodeBox)this, NameBox.class, "udta", "name");
        return nb2 == null ? null : nb2.getName();
    }

    public void fixMediaTimescale(int ts) {
        TimeToSampleBox.TimeToSampleEntry[] entries;
        MediaHeaderBox mdhd = Box.findFirst((NodeBox)this, MediaHeaderBox.class, "mdia", "mdhd");
        int oldTs = mdhd.getTimescale();
        mdhd.setTimescale(ts);
        mdhd.setDuration((long)ts * mdhd.getDuration() / (long)oldTs);
        List<Edit> edits = this.getEdits();
        if (edits != null) {
            for (Edit edit : edits) {
                edit.setMediaTime((long)ts * edit.getMediaTime() / (long)oldTs);
            }
        }
        TimeToSampleBox tts = Box.findFirst((NodeBox)this, TimeToSampleBox.class, "mdia", "minf", "stbl", "stts");
        for (TimeToSampleBox.TimeToSampleEntry tte : entries = tts.getEntries()) {
            tte.setSampleDuration(ts * tte.getSampleDuration() / oldTs);
        }
    }

    public void setName(String string) {
        NodeBox udta = TrakBox.findFirst((NodeBox)this, NodeBox.class, "udta");
        if (udta == null) {
            udta = new NodeBox(new Header("udta"));
            this.add(udta);
        }
        udta.removeChildren("name");
        udta.add(new NameBox(string));
    }

    public Size getCodedSize() {
        SampleEntry se2 = this.getSampleEntries()[0];
        if (!(se2 instanceof VideoSampleEntry)) {
            throw new IllegalArgumentException("Not a video track");
        }
        VideoSampleEntry vse = (VideoSampleEntry)se2;
        return new Size(vse.getWidth(), vse.getHeight());
    }
}

