/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jcodec.FullBox;
import org.jcodec.Header;
import org.jcodec.NIOUtils;

public class UrlBox
extends FullBox {
    private String url;

    public static String fourcc() {
        return "url ";
    }

    public UrlBox(String url) {
        super(new Header(UrlBox.fourcc()));
        this.url = url;
    }

    public UrlBox(Header atom) {
        super(atom);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        if ((this.flags & 1) != 0) {
            return;
        }
        Charset utf8 = Charset.forName("utf-8");
        this.url = NIOUtils.readNullTermString(input, utf8);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        Charset utf8 = Charset.forName("utf-8");
        if (this.url != null) {
            NIOUtils.write(out, ByteBuffer.wrap(this.url.getBytes(utf8)));
            out.put((byte)0);
        }
    }

    public String getUrl() {
        return this.url;
    }
}

