/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jcodec.Box;
import org.jcodec.Edit;
import org.jcodec.MovieBox;
import org.jcodec.NodeBox;
import org.jcodec.Rational;
import org.jcodec.TimeToSampleBox;
import org.jcodec.TrakBox;

public class Util {
    public static Pair<List<Edit>> split(List<Edit> edits, Rational trackByMv, long tvMv) {
        long total = 0L;
        ArrayList<Edit> l2 = new ArrayList<Edit>();
        ArrayList<Edit> r2 = new ArrayList<Edit>();
        ListIterator<Edit> lit = edits.listIterator();
        while (lit.hasNext()) {
            Edit edit = lit.next();
            if (total + edit.getDuration() > tvMv) {
                int leftDurMV = (int)(tvMv - total);
                int leftDurMedia = trackByMv.multiplyS(leftDurMV);
                Edit left = new Edit(leftDurMV, edit.getMediaTime(), 1.0f);
                Edit right = new Edit(edit.getDuration() - (long)leftDurMV, (long)leftDurMedia + edit.getMediaTime(), 1.0f);
                lit.remove();
                if (left.getDuration() > 0L) {
                    lit.add(left);
                    l2.add(left);
                }
                if (right.getDuration() <= 0L) break;
                lit.add(right);
                r2.add(right);
                break;
            }
            l2.add(edit);
            total += edit.getDuration();
        }
        while (lit.hasNext()) {
            r2.add(lit.next());
        }
        return new Pair<List<Edit>>(l2, r2);
    }

    public static Pair<List<Edit>> split(MovieBox movie, TrakBox track, long tvMv) {
        return Util.split(track.getEdits(), new Rational(track.getTimescale(), movie.getTimescale()), tvMv);
    }

    public static void spread(MovieBox movie, TrakBox track, long tvMv, long durationMv) {
        Pair<List<Edit>> split = Util.split(movie, track, tvMv);
        track.getEdits().add(split.getA().size(), new Edit(durationMv, -1L, 1.0f));
    }

    public static void shift(MovieBox movie, TrakBox track, long tvMv) {
        track.getEdits().add(0, new Edit(tvMv, -1L, 1.0f));
    }

    public static long[] getTimevalues(TrakBox track) {
        TimeToSampleBox stts = Box.findFirst((NodeBox)track, TimeToSampleBox.class, "mdia", "minf", "stbl", "stts");
        int count = 0;
        TimeToSampleBox.TimeToSampleEntry[] tts = stts.getEntries();
        for (int i2 = 0; i2 < tts.length; ++i2) {
            count += tts[i2].getSampleCount();
        }
        long[] tv = new long[count + 1];
        int k2 = 0;
        for (int i3 = 0; i3 < tts.length; ++i3) {
            int j2 = 0;
            while (j2 < tts[i3].getSampleCount()) {
                tv[k2 + 1] = tv[k2] + (long)tts[i3].getSampleDuration();
                ++j2;
                ++k2;
            }
        }
        return tv;
    }

    public static List<Edit> editsOnEdits(Rational mvByTrack, List<Edit> lower, List<Edit> higher) {
        ArrayList<Edit> result = new ArrayList<Edit>();
        List<Edit> next = new ArrayList<Edit>(lower);
        for (Edit edit : higher) {
            long startMv = mvByTrack.multiply(edit.getMediaTime());
            Pair<List<Edit>> split = Util.split(next, mvByTrack.flip(), startMv);
            Pair<List<Edit>> split2 = Util.split(split.getB(), mvByTrack.flip(), startMv + edit.getDuration());
            result.addAll((Collection<Edit>)split2.getA());
            next = split2.getB();
        }
        return result;
    }

    public static class Pair<T> {
        private T a;
        private T b;

        public Pair(T a2, T b2) {
            this.a = a2;
            this.b = b2;
        }

        public T getA() {
            return this.a;
        }

        public T getB() {
            return this.b;
        }
    }
}

