/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.test.InstrumentationRegistry;
import android.support.test.internal.util.Checks;
import android.support.test.rule.UiThreadTestRule;
import android.util.Log;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ActivityTestRule<T extends Activity>
extends UiThreadTestRule {
    private static final String TAG = "ActivityTestRule";
    private final Class<T> mActivityClass;
    private Instrumentation mInstrumentation;
    private boolean mInitialTouchMode = false;
    private boolean mLaunchActivity = false;
    private T mActivity;

    public ActivityTestRule(Class<T> activityClass) {
        this(activityClass, false);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode) {
        this(activityClass, initialTouchMode, true);
    }

    public ActivityTestRule(Class<T> activityClass, boolean initialTouchMode, boolean launchActivity) {
        this.mActivityClass = activityClass;
        this.mInitialTouchMode = initialTouchMode;
        this.mLaunchActivity = launchActivity;
        this.mInstrumentation = InstrumentationRegistry.getInstrumentation();
    }

    protected Intent getActivityIntent() {
        return new Intent("android.intent.action.MAIN");
    }

    protected void beforeActivityLaunched() {
    }

    protected void afterActivityLaunched() {
    }

    protected void afterActivityFinished() {
    }

    public T getActivity() {
        if (this.mActivity == null) {
            Log.w((String)TAG, (String)"Activity wasn't created yet");
        }
        return this.mActivity;
    }

    @Override
    public Statement apply(Statement base, Description description) {
        return new ActivityStatement(super.apply(base, description));
    }

    public T launchActivity(@Nullable Intent startIntent) {
        this.mInstrumentation.setInTouchMode(this.mInitialTouchMode);
        String targetPackage = this.mInstrumentation.getTargetContext().getPackageName();
        if (null == startIntent && null == (startIntent = this.getActivityIntent())) {
            Log.w((String)TAG, (String)"getActivityIntent() returned null using default: Intent(Intent.ACTION_MAIN)");
            startIntent = new Intent("android.intent.action.MAIN");
        }
        startIntent.setClassName(targetPackage, this.mActivityClass.getName());
        startIntent.addFlags(0x10000000);
        Log.d((String)TAG, (String)String.format("Launching activity %s", this.mActivityClass.getName()));
        this.beforeActivityLaunched();
        this.mActivity = (Activity)this.mActivityClass.cast(this.mInstrumentation.startActivitySync(startIntent));
        this.mInstrumentation.waitForIdleSync();
        if (this.mActivity != null) {
            this.afterActivityLaunched();
        } else {
            String errorMessage = String.format("Activity %s, failed to launch", this.mActivityClass.getName());
            Bundle bundle = new Bundle();
            bundle.putString("stream", "ActivityTestRule " + errorMessage);
            this.mInstrumentation.sendStatus(0, bundle);
            Log.e((String)TAG, (String)errorMessage);
        }
        return this.mActivity;
    }

    void setInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = (Instrumentation)Checks.checkNotNull((Object)instrumentation, (Object)"instrumentation cannot be null!");
    }

    void finishActivity() {
        if (this.mActivity != null) {
            this.mActivity.finish();
            this.afterActivityFinished();
            this.mActivity = null;
        }
    }

    private class ActivityStatement
    extends Statement {
        private final Statement mBase;

        public ActivityStatement(Statement base) {
            this.mBase = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                if (ActivityTestRule.this.mLaunchActivity) {
                    ActivityTestRule.this.mActivity = ActivityTestRule.this.launchActivity(ActivityTestRule.this.getActivityIntent());
                }
                this.mBase.evaluate();
            }
            finally {
                ActivityTestRule.this.finishActivity();
            }
        }
    }
}

