package de.halfbit.kaboom;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import javax.inject.Inject;

public class HomeFragment extends Fragment {

    @Inject ViewPager mViewPager;

    private HomeSubPagesAdapter mAdapter;

    @Nullable @Override public View onCreateView(LayoutInflater inflater,
                                                 @Nullable ViewGroup container,
                                                 @Nullable Bundle savedInstanceState) {
        // inject view pager here
        ((MainActivity) getActivity()).getComponent().inject(this);

        mAdapter = new HomeSubPagesAdapter(getChildFragmentManager());
        return mViewPager;
    }

    @Override public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewPager.setAdapter(mAdapter);
    }

    @Override public void onDestroyView() {

        // uncomment the line below to fix the issue
        //mViewPager.setAdapter(null);

        super.onDestroyView();
    }
}
