package de.halfbit.kaboom;

import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

class HomeSubPageFragment extends Fragment {

    public static final String EXT_COLOR = "color";

    public static HomeSubPageFragment create(@ColorInt int color) {
        HomeSubPageFragment fragment = new HomeSubPageFragment();
        Bundle arguments = new Bundle();
        arguments.putInt(EXT_COLOR, color);
        fragment.setArguments(arguments);
        return fragment;
    }

    @Nullable @Override public View onCreateView(LayoutInflater inflater,
                                                 @Nullable ViewGroup container,
                                                 @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_subpage, container, false);
        view.setBackgroundColor(getArguments().getInt(EXT_COLOR));
        return view;
    }

}
