package de.halfbit.kaboom;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomNavigationView;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.View;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.inject.Scope;

import dagger.Component;
import dagger.Module;
import dagger.Provides;

public class MainActivity extends AppCompatActivity {

    private BottomNavigationView.OnNavigationItemSelectedListener mOnNavigationItemSelectedListener
            = new BottomNavigationView.OnNavigationItemSelectedListener() {

        @Override
        public boolean onNavigationItemSelected(@NonNull MenuItem item) {
            switch (item.getItemId()) {
                case R.id.navigation_home:
                    showPage(HomeFragment.class);
                    return true;

                case R.id.navigation_dashboard:
                    showPage(DashboardFragment.class);
                    return true;

                case R.id.navigation_notifications:
                    showPage(NavigationFragment.class);
                    return true;
            }
            return false;
        }

    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        BottomNavigationView navigation = (BottomNavigationView) findViewById(R.id.navigation);
        navigation.setOnNavigationItemSelectedListener(mOnNavigationItemSelectedListener);

        if (savedInstanceState == null) {
            navigation.setSelectedItemId(R.id.navigation_home);
        }
    }

    private void showPage(Class<? extends Fragment> fragmentClass) {
        Fragment fragment = getSupportFragmentManager().findFragmentById(R.id.content);
        if (fragmentClass.isInstance(fragment)) {
            return;
        }

        try {
            fragment = fragmentClass.newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        getSupportFragmentManager().beginTransaction()
                .replace(R.id.content, fragment)
                .commit();
    }

    // Dagger stuff

    private MainComponent mMainComponent;

    public MainComponent getComponent() {
        if (mMainComponent == null) {
            mMainComponent = DaggerMainActivity_MainComponent.builder()
                    .mainModule(new MainModule())
                    .build();
        }
        return mMainComponent;
    }

    @Scope
    @Retention(RetentionPolicy.RUNTIME)
    public @interface ActivityScope {}

    @Module
    public class MainModule {
        @Provides @ActivityScope ViewPager provideViewPager() {
            ViewPager viewPager = new ViewPager(MainActivity.this);
            viewPager.setId(View.generateViewId());
            return viewPager;
        }
    }

    @ActivityScope
    @Component(modules = MainModule.class)
    public interface MainComponent {
        void inject(HomeFragment fragment);
    }

}