/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule.logging;

import android.app.Instrumentation;
import android.app.UiAutomation;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.support.test.InstrumentationRegistry;
import android.support.test.filters.SdkSuppress;
import android.support.test.internal.util.Checks;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class RuleLoggingUtils {
    private static final String TAG = "RuleLoggingUtils";
    public static final String LOGGING_SUB_DIR_NAME = "testdata";

    private static void assertFileContent(@Nullable String message, File file, String contentString, boolean contains) throws AssertionError, IOException {
        StringBuilder fileContents = new StringBuilder();
        boolean shouldContain = contains;
        boolean didContain = false;
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String readLine;
            while ((readLine = bufferedReader.readLine()) != null) {
                fileContents.append(readLine);
                fileContents.append(System.lineSeparator());
                if (fileContents.length() < contentString.length()) continue;
                long index = fileContents.indexOf(contentString);
                if (!shouldContain && index >= 0L) {
                    throw new AssertionError((Object)("File content found that shouldn't have been present, contentString=" + contentString));
                }
                if (contains && index >= 0L) {
                    didContain = true;
                    break;
                }
                fileContents.delete(0, fileContents.length() - contentString.length());
            }
            if (shouldContain && !didContain) {
                throw new AssertionError((Object)("File content not found that should have been present, contentString=" + contentString));
            }
        }
        catch (AssertionError exception) {
            if (message != null) {
                throw new AssertionError(message, (Throwable)((Object)exception));
            }
            throw exception;
        }
    }

    private static String getCommandFromParts(String[] commandParts) {
        StringBuilder commandBuilder = new StringBuilder();
        for (String commandPart : commandParts) {
            commandBuilder.append(commandPart);
            commandBuilder.append(" ");
        }
        return commandBuilder.toString();
    }

    private static File getTestDirectory(String className, String testName, @Nullable Integer testRunNumber) {
        Context context = InstrumentationRegistry.getTargetContext();
        File rootDir = context.getExternalFilesDir(null);
        File testFileDir = new File(rootDir, LOGGING_SUB_DIR_NAME);
        if (RuleLoggingUtils.getTranslatedTestName(className, testName) != null) {
            testFileDir = new File(testFileDir, RuleLoggingUtils.getTranslatedTestName(className, testName));
            if (testRunNumber != null) {
                testFileDir = new File(testFileDir, testRunNumber + "");
            }
        }
        if (!testFileDir.exists() && !testFileDir.mkdirs()) {
            throw new RuntimeException("Unable to create logging rules log directory.");
        }
        return testFileDir;
    }

    private static String getTranslatedTestName(String className, String testName) {
        if (className == null || testName == null) {
            return null;
        }
        String base = className + "_" + testName;
        base = base.replace("com", "c").replace("google", "g").replace("android", "a").replace("perfmatters", "pm").replace("automatingperformancetesting", "apt");
        return base;
    }

    private static void writeProcessOutputToLogcat(Process process, String logTag) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line;
            while (null != (line = bufferedReader.readLine())) {
                Log.w((String)logTag, (String)line);
            }
        }
    }

    public static void assertEmptyFile(@Nullable String message, File file) throws AssertionError, IOException {
        block41: {
            try {
                if (file.exists()) {
                    try (FileInputStream fis = new FileInputStream(file);
                         InputStreamReader isr = new InputStreamReader(fis);
                         BufferedReader br = new BufferedReader(isr);){
                        String firstLine = br.readLine();
                        if (firstLine != null && !TextUtils.isEmpty((CharSequence)firstLine)) {
                            throw new AssertionError((Object)("Expected file to be empty, but was able to read data: " + firstLine));
                        }
                        break block41;
                    }
                }
                throw new IOException("Expected file did not exist: " + file.getAbsolutePath());
            }
            catch (IOException | AssertionError exception) {
                if (message != null) {
                    throw new AssertionError(message, (Throwable)exception);
                }
                throw exception;
            }
        }
    }

    public static void assertFileContentContains(@Nullable String message, File file, String contentString) throws AssertionError, IOException {
        RuleLoggingUtils.assertFileContent(message, file, contentString, true);
    }

    public static void assertFileContentDoesNotContain(@Nullable String message, File file, String contentString) throws AssertionError, IOException {
        RuleLoggingUtils.assertFileContent(message, file, contentString, false);
    }

    public static void assertFileContentStartsWith(@Nullable String message, File file, String contentString) throws AssertionError, IOException {
        StringBuilder fileContents = new StringBuilder();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String readLine;
            while ((readLine = bufferedReader.readLine()) != null && fileContents.length() < contentString.length()) {
                fileContents.append(readLine);
                fileContents.append(System.lineSeparator());
            }
        }
        try {
            if (fileContents.length() < contentString.length()) {
                throw new AssertionError((Object)("File content wasn't long enough to match, expected=" + contentString + ", minimalStartingFileContent=" + fileContents));
            }
            if (!fileContents.substring(0, contentString.length()).equals(contentString)) {
                throw new AssertionError((Object)("File content did not match, expected=" + contentString + ", minimalStartingFileContent=" + fileContents));
            }
        }
        catch (AssertionError exception) {
            if (message != null) {
                throw new AssertionError(message, (Throwable)((Object)exception));
            }
            throw exception;
        }
    }

    public static File getTestDir(String className, String testName, int testRunNumber) {
        Checks.checkState((testRunNumber >= 0 ? 1 : 0) != 0, (Object)("Invalid test run number (" + testRunNumber + ")"));
        return RuleLoggingUtils.getTestDirectory(className, testName, testRunNumber);
    }

    public static File getTestFile(String className, String testName, String filename, int testRunNumber) {
        return new File(RuleLoggingUtils.getTestDir(className, testName, testRunNumber), filename);
    }

    public static File getTestRunDir() {
        return RuleLoggingUtils.getTestDirectory(null, null, null);
    }

    public static File getTestRunFile(String filename) {
        return new File(RuleLoggingUtils.getTestDirectory(null, null, null), filename);
    }

    public static void printFileToLogcat(File logFile, String logcatTag) throws IOException {
        try (FileReader fileReader = new FileReader(logFile);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            Log.w((String)logcatTag, (String)("Logging file located at " + logFile.getAbsolutePath()));
            while (null != (line = bufferedReader.readLine())) {
                Log.w((String)logcatTag, (String)line);
            }
        }
    }

    @SdkSuppress(minSdkVersion=21)
    public static void startCmdAndLogOutputPostL(String[] commandParts, File logFile) {
        try {
            Instrumentation testingInstrumentation = InstrumentationRegistry.getInstrumentation();
            UiAutomation uiAutomation = testingInstrumentation.getUiAutomation();
            String command = RuleLoggingUtils.getCommandFromParts(commandParts);
            try (ParcelFileDescriptor.AutoCloseInputStream inputStream = new ParcelFileDescriptor.AutoCloseInputStream(uiAutomation.executeShellCommand(command));
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream);
                 BufferedReader reader = new BufferedReader(inputStreamReader);
                 FileWriter fileWriter = new FileWriter(logFile);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                String line;
                while (null != (line = reader.readLine())) {
                    bufferedWriter.write(line);
                    bufferedWriter.write(System.lineSeparator());
                }
            }
        }
        catch (Exception exception) {
            RuleLoggingUtils.writeErrorToFileAndLogcat(logFile, TAG, "Couldn't start and write process output", exception);
        }
    }

    public static Process startProcess(String[] commandParts) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commandParts);
        processBuilder.redirectErrorStream();
        return processBuilder.start();
    }

    public static void startProcessAndLogToFile(String[] commandParts, File logFile, int androidVersion) {
        if (androidVersion > 21) {
            RuleLoggingUtils.startCmdAndLogOutputPostL(commandParts, logFile);
        } else {
            RuleLoggingUtils.startProcessAndWriteOutputToFilePreL(commandParts, logFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startProcessAndWriteOutputToFilePreL(String[] commandParts, File logFile) {
        Process process = null;
        try {
            process = RuleLoggingUtils.startProcess(commandParts);
            process.waitFor();
            RuleLoggingUtils.writeProcessOutputToFile(process, logFile);
        }
        catch (IOException | InterruptedException exception) {
            RuleLoggingUtils.writeErrorToFileAndLogcat(logFile, TAG, "Couldn't start and write process output", exception);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static void writeErrorToFileAndLogcat(File file, String logTag, String errorMessage, @Nullable Exception exception) {
        if (exception != null) {
            Log.e((String)logTag, (String)errorMessage, (Throwable)exception);
        } else {
            Log.e((String)logTag, (String)errorMessage);
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.append(errorMessage);
            fileWriter.append(System.lineSeparator());
            if (exception != null) {
                fileWriter.append(exception.toString());
            }
        }
        catch (IOException ioexception) {
            Log.e((String)logTag, (String)("Unable to log error to file " + file.getAbsolutePath()), (Throwable)ioexception);
        }
    }

    public static void writeProcessOutputToFile(Process process, File logFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(logFile);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
             InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line;
            while (null != (line = bufferedReader.readLine())) {
                bufferedWriter.append(line);
                bufferedWriter.append(System.lineSeparator());
            }
        }
    }
}

