/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.idling;

import android.os.SystemClock;
import android.support.test.espresso.IdlingResource;
import android.text.TextUtils;
import android.util.Log;
import java.util.concurrent.atomic.AtomicInteger;

public final class CountingIdlingResource
implements IdlingResource {
    private static final String TAG = "CountingIdlingResource";
    private final String resourceName;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final boolean debugCounting;
    private volatile IdlingResource.ResourceCallback resourceCallback;
    private volatile long becameBusyAt = 0L;
    private volatile long becameIdleAt = 0L;

    public CountingIdlingResource(String resourceName) {
        this(resourceName, false);
    }

    public CountingIdlingResource(String resourceName, boolean debugCounting) {
        if (TextUtils.isEmpty((CharSequence)resourceName)) {
            throw new IllegalArgumentException("resourceName cannot be empty or null!");
        }
        this.resourceName = resourceName;
        this.debugCounting = debugCounting;
    }

    @Override
    public String getName() {
        return this.resourceName;
    }

    @Override
    public boolean isIdleNow() {
        return this.counter.get() == 0;
    }

    @Override
    public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
        this.resourceCallback = resourceCallback;
    }

    public void increment() {
        int counterVal = this.counter.getAndIncrement();
        if (0 == counterVal) {
            this.becameBusyAt = SystemClock.uptimeMillis();
        }
        if (this.debugCounting) {
            Log.i((String)TAG, (String)("Resource: " + this.resourceName + " in-use-count incremented to: " + (counterVal + 1)));
        }
    }

    public void decrement() {
        int counterVal = this.counter.decrementAndGet();
        if (counterVal == 0) {
            if (null != this.resourceCallback) {
                this.resourceCallback.onTransitionToIdle();
            }
            this.becameIdleAt = SystemClock.uptimeMillis();
        }
        if (this.debugCounting) {
            if (counterVal == 0) {
                Log.i((String)TAG, (String)("Resource: " + this.resourceName + " went idle! (Time spent not idle: " + (this.becameIdleAt - this.becameBusyAt) + ")"));
            } else {
                Log.i((String)TAG, (String)("Resource: " + this.resourceName + " in-use-count decremented to: " + counterVal));
            }
        }
        if (counterVal <= -1) {
            throw new IllegalStateException("Counter has been corrupted! counterVal=" + counterVal);
        }
    }

    public void dumpStateToLogs() {
        StringBuilder message = new StringBuilder("Resource: ").append(this.resourceName).append(" inflight transaction count: ").append(this.counter.get());
        if (0L == this.becameBusyAt) {
            Log.i((String)TAG, (String)message.append(" and has never been busy!").toString());
        } else {
            message.append(" and was last busy at: ").append(this.becameBusyAt);
            if (0L == this.becameIdleAt) {
                Log.w((String)TAG, (String)message.append(" AND NEVER WENT IDLE!").toString());
            } else {
                message.append(" and last went idle at: ").append(this.becameIdleAt);
                Log.i((String)TAG, (String)message.toString());
            }
        }
    }
}

