/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.RequiresApi;
import android.support.v4.widget.TintableCompoundButton;
import android.util.Log;
import android.widget.CompoundButton;
import java.lang.reflect.Field;

@RequiresApi(value=9)
@TargetApi(value=9)
class CompoundButtonCompatGingerbread {
    private static final String TAG = "CompoundButtonCompatGingerbread";
    private static Field sButtonDrawableField;
    private static boolean sButtonDrawableFieldFetched;

    CompoundButtonCompatGingerbread() {
    }

    static void setButtonTintList(CompoundButton button, ColorStateList tint) {
        if (button instanceof TintableCompoundButton) {
            ((TintableCompoundButton)button).setSupportButtonTintList(tint);
        }
    }

    static ColorStateList getButtonTintList(CompoundButton button) {
        if (button instanceof TintableCompoundButton) {
            return ((TintableCompoundButton)button).getSupportButtonTintList();
        }
        return null;
    }

    static void setButtonTintMode(CompoundButton button, PorterDuff.Mode tintMode) {
        if (button instanceof TintableCompoundButton) {
            ((TintableCompoundButton)button).setSupportButtonTintMode(tintMode);
        }
    }

    static PorterDuff.Mode getButtonTintMode(CompoundButton button) {
        if (button instanceof TintableCompoundButton) {
            return ((TintableCompoundButton)button).getSupportButtonTintMode();
        }
        return null;
    }

    static Drawable getButtonDrawable(CompoundButton button) {
        if (!sButtonDrawableFieldFetched) {
            try {
                sButtonDrawableField = CompoundButton.class.getDeclaredField("mButtonDrawable");
                sButtonDrawableField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.i((String)TAG, (String)"Failed to retrieve mButtonDrawable field", (Throwable)e);
            }
            sButtonDrawableFieldFetched = true;
        }
        if (sButtonDrawableField != null) {
            try {
                return (Drawable)sButtonDrawableField.get(button);
            }
            catch (IllegalAccessException e) {
                Log.i((String)TAG, (String)"Failed to get button drawable via reflection", (Throwable)e);
                sButtonDrawableField = null;
            }
        }
        return null;
    }
}

