/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AlertDialogLayout
extends LinearLayoutCompat {
    public AlertDialogLayout(@Nullable Context context) {
        super(context);
    }

    public AlertDialogLayout(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.tryOnMeasure(widthMeasureSpec, heightMeasureSpec)) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean tryOnMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightSpec;
        int heightToGive;
        View topPanel = null;
        View buttonPanel = null;
        View middlePanel = null;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int id2 = child.getId();
            if (id2 == R.id.topPanel) {
                topPanel = child;
                continue;
            }
            if (id2 == R.id.buttonPanel) {
                buttonPanel = child;
                continue;
            }
            if (id2 == R.id.contentPanel || id2 == R.id.customPanel) {
                if (middlePanel != null) {
                    return false;
                }
                middlePanel = child;
                continue;
            }
            return false;
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int childState = 0;
        int usedHeight = this.getPaddingTop() + this.getPaddingBottom();
        if (topPanel != null) {
            topPanel.measure(widthMeasureSpec, 0);
            usedHeight += topPanel.getMeasuredHeight();
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)topPanel));
        }
        int buttonHeight = 0;
        int buttonWantsHeight = 0;
        if (buttonPanel != null) {
            buttonPanel.measure(widthMeasureSpec, 0);
            buttonHeight = AlertDialogLayout.resolveMinimumHeight(buttonPanel);
            buttonWantsHeight = buttonPanel.getMeasuredHeight() - buttonHeight;
            usedHeight += buttonHeight;
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)buttonPanel));
        }
        int middleHeight = 0;
        if (middlePanel != null) {
            int childHeightSpec2 = heightMode == 0 ? 0 : View.MeasureSpec.makeMeasureSpec((int)Math.max(0, heightSize - usedHeight), (int)heightMode);
            middlePanel.measure(widthMeasureSpec, childHeightSpec2);
            middleHeight = middlePanel.getMeasuredHeight();
            usedHeight += middleHeight;
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)middlePanel));
        }
        int remainingHeight = heightSize - usedHeight;
        if (buttonPanel != null) {
            usedHeight -= buttonHeight;
            heightToGive = Math.min(remainingHeight, buttonWantsHeight);
            if (heightToGive > 0) {
                remainingHeight -= heightToGive;
                buttonHeight += heightToGive;
            }
            childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)buttonHeight, (int)0x40000000);
            buttonPanel.measure(widthMeasureSpec, childHeightSpec);
            usedHeight += buttonPanel.getMeasuredHeight();
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)buttonPanel));
        }
        if (middlePanel != null && remainingHeight > 0) {
            usedHeight -= middleHeight;
            heightToGive = remainingHeight;
            remainingHeight -= heightToGive;
            childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)(middleHeight += heightToGive), (int)heightMode);
            middlePanel.measure(widthMeasureSpec, childHeightSpec);
            usedHeight += middlePanel.getMeasuredHeight();
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)middlePanel));
        }
        int maxWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
        }
        int widthSizeAndState = ViewCompat.resolveSizeAndState((int)(maxWidth += this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)childState);
        int heightSizeAndState = ViewCompat.resolveSizeAndState((int)usedHeight, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(widthSizeAndState, heightSizeAndState);
        if (widthMode != 0x40000000) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
        return true;
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LinearLayoutCompat.LayoutParams lp = (LinearLayoutCompat.LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    private static int resolveMinimumHeight(View v) {
        ViewGroup vg;
        int minHeight = ViewCompat.getMinimumHeight((View)v);
        if (minHeight > 0) {
            return minHeight;
        }
        if (v instanceof ViewGroup && (vg = (ViewGroup)v).getChildCount() == 1) {
            return AlertDialogLayout.resolveMinimumHeight(vg.getChildAt(0));
        }
        return 0;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int paddingLeft = this.getPaddingLeft();
        int width = right - left;
        int childRight = width - this.getPaddingRight();
        int childSpace = width - paddingLeft - this.getPaddingRight();
        int totalLength = this.getMeasuredHeight();
        int count = this.getChildCount();
        int gravity = this.getGravity();
        int majorGravity = gravity & 0x70;
        int minorGravity = gravity & 0x800007;
        switch (majorGravity) {
            case 80: {
                int childTop = this.getPaddingTop() + bottom - top - totalLength;
                break;
            }
            case 16: {
                int childTop = this.getPaddingTop() + (bottom - top - totalLength) / 2;
                break;
            }
            default: {
                int childTop = this.getPaddingTop();
            }
        }
        Drawable dividerDrawable = this.getDividerDrawable();
        int dividerHeight = dividerDrawable == null ? 0 : dividerDrawable.getIntrinsicHeight();
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LinearLayoutCompat.LayoutParams lp = (LinearLayoutCompat.LayoutParams)child.getLayoutParams();
            int layoutGravity = lp.gravity;
            if (layoutGravity < 0) {
                layoutGravity = minorGravity;
            }
            int layoutDirection = ViewCompat.getLayoutDirection((View)this);
            int absoluteGravity = GravityCompat.getAbsoluteGravity((int)layoutGravity, (int)layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(i)) {
                childTop += dividerHeight;
            }
            this.setChildFrame(child, childLeft, childTop += lp.topMargin, childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
    }

    private void setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }
}

