package com.aquilescanta.browsearleakdemoapp

import android.app.Activity
import android.content.ComponentName
import android.content.Intent
import android.os.Bundle
import android.support.v4.media.MediaBrowserCompat
import android.support.v4.media.MediaBrowserCompat.MediaItem
import android.support.v4.media.session.MediaSessionCompat
import android.util.Log
import androidx.media.MediaBrowserServiceCompat
import androidx.media.session.MediaButtonReceiver
import leakcanary.AppWatcher


class MainActivity : Activity() {
    private var mediaBrowser: MediaBrowserCompat? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        Log.d(
            TAG,
            "onCreate() called with: savedInstanceState = [$savedInstanceState]"
        )
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        val connectionCallback = MyConnectionCallback()
        mediaBrowser = MediaBrowserCompat(
            applicationContext,
            ComponentName(this, BrowserService::class.java),
            connectionCallback,
            null
        )
    }

    override fun onStart() {
        Log.d(TAG, "onStart() called")
        super.onStart()
        mediaBrowser?.connect()
    }

    override fun onStop() {
        Log.d(TAG, "onStop() called")
        mediaBrowser?.disconnect()
        super.onStop()
    }

    private class MyConnectionCallback : MediaBrowserCompat.ConnectionCallback() {
        override fun onConnected() {
            Log.d(TAG, "onConnected() called")
        }

        override fun onConnectionSuspended() {
            Log.d(TAG, "onConnectionSuspended() called")
        }

        override fun onConnectionFailed() {
            Log.d(TAG, "onConnectionFailed() called")
        }
    }

    companion object {
        private val TAG = MainActivity::class.java.simpleName
    }
}

class BrowserService : MediaBrowserServiceCompat() {
    private var mediaSession: MediaSessionCompat? = null
    override fun onCreate() {
        Log.d(TAG, "onCreate() called")
        super.onCreate()
        mediaSession = MediaSessionCompat(this, TAG)
    }

    override fun onDestroy() {
        Log.d(TAG, "onDestroy() called")
        mediaSession?.release()
        AppWatcher.objectWatcher.expectWeaklyReachable(
            this,
            "An explanation of why this should be garbage collected."
        )
    }

    override fun onStartCommand(intent: Intent, flags: Int, startId: Int): Int {
        Log.d(
            TAG,
            "onStartCommand() called with: intent = [$intent], flags = [$flags], startId = [$startId]"
        )
        MediaButtonReceiver.handleIntent(mediaSession, intent)
        return START_NOT_STICKY
    }

    override fun onGetRoot(
        clientPackageName: String, clientUid: Int,
        rootHints: Bundle?
    ): BrowserRoot? {
        return BrowserRoot("BrowserLeakApp", null)
    }

    override fun onLoadChildren(
        parentId: String,
        result: Result<List<MediaItem?>?>
    ) {
        result.sendResult(null)
    }

    companion object {
        private val TAG = BrowserService::class.java.simpleName
    }
}
