package testapp.testapplication;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {
    public static final String BACKSTACK_TAG = "myfragment";

    Fragment f;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        if (savedInstanceState == null) {
            f = MyFragment.newInstance(0);
            getSupportFragmentManager().beginTransaction().add(R.id.fragment_holder, f).addToBackStack(MainActivity.BACKSTACK_TAG).commit();
        } else {
            f = getSupportFragmentManager().findFragmentById(R.id.fragment_holder);
        }
    }

    @Override
    public void onBackPressed() {
        if (getSupportFragmentManager().getBackStackEntryCount() > 1) {
            f.getFragmentManager().popBackStack(MainActivity.BACKSTACK_TAG, 0);
        } else {
            finish();
        }
    }
}
