package testapp.testapplication;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

public class MyFragment extends android.support.v4.app.Fragment {
    int nestCount;

    public static MyFragment newInstance(int nestCount) {
        MyFragment f = new MyFragment();
        Bundle b = new Bundle(1);
        b.putInt("nestCount", nestCount);
        f.setArguments(b);
        return f;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.my_fragment, container, false);

        if (getArguments() != null) {
            nestCount = getArguments().getInt("nestCount");
        }

        postponeEnterTransition();
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
            @Override
            public void run() {
                startPostponedEnterTransition();
            }
        }, 100);

        int color;
        switch (nestCount) {
            case 0: color = 0xff0000ff; break;
            case 1: color = 0xffffff00; break;
            default: color = 0xffff00ff;
        }
        v.setBackgroundColor(color);

        ((TextView) v.findViewById(R.id.textview)).setText("child fragment #" + nestCount);

        Button button = (Button) v.findViewById(R.id.button);
        Button buttonOpt = (Button) v.findViewById(R.id.button_opt);
        if (nestCount < 2) {
            OnClickListener listener = new OnClickListener() {
                @Override
                public void onClick(View v) {
                    doFrag(v.getId() == R.id.button_opt);
                }
            };
            button.setOnClickListener(listener);
            buttonOpt.setOnClickListener(listener);
        } else {
            button.setVisibility(View.GONE);
            buttonOpt.setVisibility(View.GONE);
        }

        return v;
    }

    private void doFrag(boolean allowOptimization) {
        FragmentTransaction ft = getFragmentManager().beginTransaction();
        ft.setAllowOptimization(allowOptimization);
        ft.setCustomAnimations(R.anim.slide_in_right, R.anim.slide_out_left, R.anim.slide_in_left, R.anim.slide_out_right);
        ft.replace(R.id.fragment_holder, MyFragment.newInstance(nestCount + 1));
        ft.addToBackStack(null);
        ft.commit();
    }
}
