package com.example.animatedcontentbug.tab

import androidx.compose.runtime.Composable
import androidx.compose.runtime.State
import androidx.compose.ui.graphics.painter.Painter
import cafe.adriel.voyager.androidx.AndroidScreenLifecycleOwner
import cafe.adriel.voyager.core.lifecycle.ScreenLifecycleOwner
import cafe.adriel.voyager.core.lifecycle.ScreenLifecycleProvider
import cafe.adriel.voyager.core.screen.Screen
import cafe.adriel.voyager.core.screen.ScreenKey
import cafe.adriel.voyager.core.screen.uniqueScreenKey

@Composable
fun CurrentTab() {
    val tabNavigator = LocalTabNavigator.current
    val currentTab = tabNavigator.current

    tabNavigator.SaveableState("currentTab" + currentTab.key) {
        currentTab.Content()
    }
}

data class TabOptions(
    val title: String,
    val icon: Painter,
    val selectedIcon: Painter,
)

abstract class Tab : UniqueScreen() {

    open fun onDispose() = Unit

    abstract val isRoot: State<Boolean>

    abstract val options: TabOptions
        @Composable get
}

abstract class UniqueScreen : Screen, ScreenLifecycleProvider {
    override val key: ScreenKey = uniqueScreenKey
    override fun getLifecycleOwner(): ScreenLifecycleOwner = AndroidScreenLifecycleOwner.get(this)

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UniqueScreen

        return key == other.key
    }

    override fun hashCode(): Int {
        return key.hashCode()
    }
}
