package com.example.animatedcontentbug.ui

import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.rememberVectorPainter
import androidx.compose.ui.res.stringResource
import cafe.adriel.voyager.core.annotation.InternalVoyagerApi
import cafe.adriel.voyager.core.screen.Screen
import cafe.adriel.voyager.navigator.Navigator
import cafe.adriel.voyager.navigator.compositionUniqueId
import com.example.animatedcontentbug.tab.Tab
import com.example.animatedcontentbug.tab.TabOptions

abstract class BaseTab : Tab() {

    abstract val icon: ImageVector
    abstract val selectedIcon: ImageVector
    abstract val titleRestId: Int

    override val options: TabOptions
        @androidx.compose.runtime.Stable
        @Composable
        get() {
            val icon = rememberVectorPainter(icon)
            val selectedIcon = rememberVectorPainter(selectedIcon)
            val title = stringResource(id = titleRestId)

            return remember {
                TabOptions(title = title, icon = icon, selectedIcon = selectedIcon)
            }
        }

    @Transient
    private var currentVoyagerNavigator: Navigator? = null

    @OptIn(InternalVoyagerApi::class)
    override fun onDispose() {
        currentVoyagerNavigator?.let { navigator ->
            for (screen in navigator.items) {
                navigator.dispose(screen)
            }
            navigator.clearEvent()
        }
        currentVoyagerNavigator = null
    }

    abstract val startDestination: Screen

    @Transient
    override var isRoot: MutableState<Boolean> = mutableStateOf(false)

    @Composable
    override fun Content() {
        @OptIn(InternalVoyagerApi::class)
        val subKey: String = compositionUniqueId()
        Navigator(screen = startDestination, key = subKey) {
            currentVoyagerNavigator = it
            FadeTransition(navigator = it)
        }
    }
}
