package com.example.animatedcontentbug.ui

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.example.animatedcontentbug.tab.LocalTabNavigator
import com.example.animatedcontentbug.tab.UniqueScreen

class FirstTabContent : UniqueScreen() {
    @Composable
    override fun Content() {
        Box(
            modifier = Modifier
                .fillMaxSize()
                .background(Color.Red)
        ) {
            val navigator = cafe.adriel.voyager.navigator.LocalNavigator.current
            Column {
                val localTabNavigator = LocalTabNavigator.current
                Button(onClick = { localTabNavigator.current = SecondTab() }) { Text("Go next") }
                Box(
                    modifier = Modifier
                        .fillMaxSize()
                        .background(Color.Green)
                ) {
                    Button(onClick = { navigator?.push(FirstScreen2Content()) }) { Text("Toggle") }
                }

            }
        }
    }
}