/*
 * Decompiled with CFR 0.152.
 */
package com.example.sample;

import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Spanned;
import com.example.sample.HtmlToSpannedConverter;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Html {
    public static Spanned fromHtml(String source) {
        return Html.fromHtml(source, null, null);
    }

    public static Spanned fromHtml(String source, ImageGetter imageGetter, TagHandler tagHandler) {
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", (Object)HtmlParser.schema);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        HtmlToSpannedConverter converter = new HtmlToSpannedConverter(source, imageGetter, tagHandler, parser);
        return converter.convert();
    }

    private Html() {
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1);
    }

    public static interface TagHandler {
        public void handleTag(boolean var1, String var2, Editable var3, XMLReader var4);
    }

    private static class HtmlParser {
        private static final HTMLSchema schema = new HTMLSchema();

        private HtmlParser() {
        }
    }
}

