import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask

plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
}

android {
    namespace = "io.github.iosephknecht.agp.fit.to.content.bug"
    compileSdk = 35

    defaultConfig {
        applicationId = "io.github.iosephknecht.agp.fit.to.content.bug"
        minSdk = 24
        targetSdk = 35
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        debug {
            isDebuggable = false
        }
        release {
            isDebuggable = false
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
}

dependencies {
    implementation("io.github.iosephknecht:feature-1:1.0.0")
}

if (property("android.toFitInMemoryFix").toString().toBoolean()) {
    afterEvaluate {
        tasks.withType(PerModuleReportDependenciesTask::class.java) {
            val originalArtifactCollection = runtimeClasspathArtifacts.get()
            runtimeClasspathArtifacts.set(
                LargeFileFilteringArtifactCollection(originalArtifactCollection)
            )
        }
    }
}

class LargeFileFilteringArtifactCollection(
    private val artifactCollection: ArtifactCollection
) : ArtifactCollection {

    override fun iterator(): MutableIterator<ResolvedArtifactResult> {
        val newIterator = artifactCollection
            .asSequence()
            .filter { result -> result.file.length() < Int.MAX_VALUE }
            .iterator()

        return object : MutableIterator<ResolvedArtifactResult> {

            override fun hasNext(): Boolean {
                return newIterator.hasNext()
            }

            override fun next(): ResolvedArtifactResult {
                return newIterator.next()
            }

            override fun remove() {
                error("unsupported")
            }
        }
    }

    override fun getArtifactFiles(): FileCollection {
        return artifactCollection
            .artifactFiles
            .filter { it.length() < Int.MAX_VALUE }
    }

    override fun getArtifacts(): MutableSet<ResolvedArtifactResult> {
        return artifactCollection
            .artifacts
            .filterTo(LinkedHashSet()) { result -> result.file.length() < Int.MAX_VALUE }
    }

    override fun getResolvedArtifacts(): Provider<MutableSet<ResolvedArtifactResult>> {
        return artifactCollection
            .resolvedArtifacts
            .map {
                it.filterTo(LinkedHashSet()) { result -> result.file.length() < Int.MAX_VALUE }
            }
    }

    override fun getFailures(): MutableCollection<Throwable> {
        return artifactCollection.failures
    }
}