package com.example.crashsample

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.webkit.WebView
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.Button
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.ui.Modifier
import androidx.compose.ui.viewinterop.AndroidView
import com.example.crashsample.ui.theme.CrashSampleTheme


class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContent {
            CrashSampleTheme {
                Scaffold(modifier = Modifier.fillMaxSize()) { innerPadding ->
                    LazyColumn(modifier = Modifier.padding(innerPadding)) {
                        items(200) { index ->
                            when (index % 2 == 0) {
                                true -> {
                                    AndroidView(factory = { context ->
                                        WebView(context).apply {
                                            loadUrl("https://www.google.com")
                                        }
                                    })
                                }

                                false -> {
                                    Button(modifier = Modifier.fillMaxWidth(), onClick = {
                                        val url = "https://www.google.com"
                                        val i = Intent(Intent.ACTION_VIEW)
                                        i.setData(Uri.parse(url))
                                        startActivity(i)
                                    }) {
                                        Column {
                                            Text("Button $index")
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}