/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics.drawable;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.a.L;
import androidx.a.M;
import androidx.a.Q;
import androidx.a.V;
import androidx.a.W;
import androidx.a.ae;
import androidx.a.k;
import androidx.a.q;
import androidx.a.w;
import androidx.core.b.b;
import androidx.core.b.b.m;
import androidx.core.graphics.drawable.a;
import androidx.core.m.l;
import androidx.versionedparcelable.CustomVersionedParcelable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;

public class IconCompat
extends CustomVersionedParcelable {
    private static final String l = "IconCompat";
    public static final int a = -1;
    private static final float m = 0.25f;
    private static final float n = 0.6666667f;
    private static final float o = 0.9166667f;
    private static final float p = 0.010416667f;
    private static final float q = 0.020833334f;
    private static final int r = 61;
    private static final int s = 30;
    private static final String t = "type";
    private static final String u = "obj";
    private static final String v = "int1";
    private static final String w = "int2";
    private static final String x = "tint_list";
    private static final String y = "tint_mode";
    @V(a={W.c})
    public int b = -1;
    Object c;
    @V(a={W.a})
    public byte[] d = null;
    @V(a={W.a})
    public Parcelable e = null;
    @V(a={W.a})
    public int f = 0;
    @V(a={W.a})
    public int g = 0;
    @V(a={W.a})
    public ColorStateList h = null;
    static final PorterDuff.Mode i = PorterDuff.Mode.SRC_IN;
    PorterDuff.Mode j = i;
    @V(a={W.a})
    public String k = null;

    public static IconCompat a(Context context, @q int n2) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        return IconCompat.a(context.getResources(), context.getPackageName(), n2);
    }

    @V(a={W.c})
    public static IconCompat a(Resources resources, String string, @q int n2) {
        if (string == null) {
            throw new IllegalArgumentException("Package must not be null.");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Drawable resource ID must not be 0");
        }
        IconCompat iconCompat = new IconCompat(2);
        iconCompat.f = n2;
        if (resources != null) {
            try {
                iconCompat.c = resources.getResourceName(n2);
            }
            catch (Resources.NotFoundException notFoundException) {
                throw new IllegalArgumentException("Icon resource cannot be found");
            }
        } else {
            iconCompat.c = string;
        }
        return iconCompat;
    }

    public static IconCompat a(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat iconCompat = new IconCompat(1);
        iconCompat.c = bitmap;
        return iconCompat;
    }

    public static IconCompat b(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat iconCompat = new IconCompat(5);
        iconCompat.c = bitmap;
        return iconCompat;
    }

    public static IconCompat a(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        IconCompat iconCompat = new IconCompat(3);
        iconCompat.c = byArray;
        iconCompat.f = n2;
        iconCompat.g = n3;
        return iconCompat;
    }

    public static IconCompat a(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        IconCompat iconCompat = new IconCompat(4);
        iconCompat.c = string;
        return iconCompat;
    }

    public static IconCompat a(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        return IconCompat.a(uri.toString());
    }

    @V(a={W.a})
    public IconCompat() {
    }

    private IconCompat(int n2) {
        this.b = n2;
    }

    public int a() {
        if (this.b == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.b((Icon)this.c);
        }
        return this.b;
    }

    @L
    public String b() {
        if (this.b == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.c((Icon)this.c);
        }
        if (this.b != 2) {
            throw new IllegalStateException("called getResPackage() on " + (Object)((Object)this));
        }
        return ((String)this.c).split(":", -1)[0];
    }

    @w
    public int c() {
        if (this.b == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.d((Icon)this.c);
        }
        if (this.b != 2) {
            throw new IllegalStateException("called getResId() on " + (Object)((Object)this));
        }
        return this.f;
    }

    @V(a={W.c})
    @M
    public Bitmap d() {
        if (this.b == -1 && Build.VERSION.SDK_INT >= 23) {
            if (this.c instanceof Bitmap) {
                return (Bitmap)this.c;
            }
            return null;
        }
        if (this.b == 1) {
            return (Bitmap)this.c;
        }
        if (this.b == 5) {
            return IconCompat.a((Bitmap)this.c, true);
        }
        throw new IllegalStateException("called getBitmap() on " + (Object)((Object)this));
    }

    @L
    public Uri e() {
        if (this.b == -1 && Build.VERSION.SDK_INT >= 23) {
            return IconCompat.e((Icon)this.c);
        }
        return Uri.parse((String)((String)this.c));
    }

    public IconCompat a(@k int n2) {
        return this.a(ColorStateList.valueOf((int)n2));
    }

    public IconCompat a(ColorStateList colorStateList) {
        this.h = colorStateList;
        return this;
    }

    public IconCompat a(PorterDuff.Mode mode) {
        this.j = mode;
        return this;
    }

    @Q(a=23)
    public Icon f() {
        Icon icon;
        switch (this.b) {
            case -1: {
                return (Icon)this.c;
            }
            case 1: {
                icon = Icon.createWithBitmap((Bitmap)((Bitmap)this.c));
                break;
            }
            case 5: {
                if (Build.VERSION.SDK_INT >= 26) {
                    icon = Icon.createWithAdaptiveBitmap((Bitmap)((Bitmap)this.c));
                    break;
                }
                icon = Icon.createWithBitmap((Bitmap)IconCompat.a((Bitmap)this.c, false));
                break;
            }
            case 2: {
                icon = Icon.createWithResource((String)this.b(), (int)this.f);
                break;
            }
            case 3: {
                icon = Icon.createWithData((byte[])((byte[])this.c), (int)this.f, (int)this.g);
                break;
            }
            case 4: {
                icon = Icon.createWithContentUri((String)((String)this.c));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
        if (this.h != null) {
            icon.setTintList(this.h);
        }
        if (this.j != i) {
            icon.setTintMode(this.j);
        }
        return icon;
    }

    @V(a={W.c})
    public void a(Context context) {
        if (this.b == 2) {
            String string = (String)this.c;
            if (!string.contains(":")) {
                return;
            }
            String string2 = string.split(":", -1)[1];
            String string3 = string2.split("/", -1)[0];
            string2 = string2.split("/", -1)[1];
            Resources resources = IconCompat.a(context, string = string.split(":", -1)[0]);
            int n2 = resources.getIdentifier(string2, string3, string);
            if (this.f != n2) {
                Log.i((String)l, (String)("Id has changed for " + string + "/" + string2));
                this.f = n2;
            }
        }
    }

    public Drawable b(Context context) {
        this.a(context);
        if (Build.VERSION.SDK_INT >= 23) {
            return this.f().loadDrawable(context);
        }
        Drawable drawable = this.c(context);
        if (drawable != null && (this.h != null || this.j != i)) {
            drawable.mutate();
            androidx.core.graphics.drawable.a.a(drawable, this.h);
            androidx.core.graphics.drawable.a.a(drawable, this.j);
        }
        return drawable;
    }

    private Drawable c(Context context) {
        switch (this.b) {
            case 1: {
                return new BitmapDrawable(context.getResources(), (Bitmap)this.c);
            }
            case 5: {
                return new BitmapDrawable(context.getResources(), IconCompat.a((Bitmap)this.c, false));
            }
            case 2: {
                String string = this.b();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = context.getPackageName();
                }
                Resources resources = IconCompat.a(context, string);
                try {
                    return androidx.core.b.b.m.a(resources, this.f, context.getTheme());
                }
                catch (RuntimeException runtimeException) {
                    Log.e((String)l, (String)String.format("Unable to load resource 0x%08x from pkg=%s", this.f, this.c), (Throwable)runtimeException);
                    break;
                }
            }
            case 3: {
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray((byte[])((byte[])this.c), (int)this.f, (int)this.g));
            }
            case 4: {
                Uri uri = Uri.parse((String)((String)this.c));
                String string = uri.getScheme();
                InputStream inputStream = null;
                if ("content".equals(string) || "file".equals(string)) {
                    try {
                        inputStream = context.getContentResolver().openInputStream(uri);
                    }
                    catch (Exception exception) {
                        Log.w((String)l, (String)("Unable to load image from URI: " + uri), (Throwable)exception);
                    }
                } else {
                    try {
                        inputStream = new FileInputStream(new File((String)this.c));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.w((String)l, (String)("Unable to load image from path: " + uri), (Throwable)fileNotFoundException);
                    }
                }
                if (inputStream == null) break;
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeStream((InputStream)inputStream));
            }
        }
        return null;
    }

    private static Resources a(Context context, String string) {
        if ("android".equals(string)) {
            return Resources.getSystem();
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string, 8192);
            if (applicationInfo != null) {
                return packageManager.getResourcesForApplication(applicationInfo);
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)l, (String)String.format("Unable to find pkg=%s for icon", string), (Throwable)nameNotFoundException);
            return null;
        }
    }

    @V(a={W.c})
    public void a(@L Intent intent, @M Drawable drawable, @L Context context) {
        Bitmap bitmap;
        this.a(context);
        switch (this.b) {
            case 1: {
                bitmap = (Bitmap)this.c;
                if (drawable == null) break;
                bitmap = bitmap.copy(bitmap.getConfig(), true);
                break;
            }
            case 5: {
                bitmap = IconCompat.a((Bitmap)this.c, true);
                break;
            }
            case 2: {
                try {
                    Context context2 = context.createPackageContext(this.b(), 0);
                    if (drawable == null) {
                        intent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)context2, (int)this.f));
                        return;
                    }
                    Drawable drawable2 = androidx.core.b.b.a(context2, this.f);
                    if (drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0) {
                        int n2 = ((ActivityManager)context2.getSystemService("activity")).getLauncherLargeIconSize();
                        bitmap = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    } else {
                        bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                    drawable2.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
                    drawable2.draw(new Canvas(bitmap));
                    break;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    throw new IllegalArgumentException("Can't find package " + this.c, nameNotFoundException);
                }
            }
            default: {
                throw new IllegalArgumentException("Icon type not supported for intent shortcuts");
            }
        }
        if (drawable != null) {
            int n3 = bitmap.getWidth();
            int n4 = bitmap.getHeight();
            drawable.setBounds(n3 / 2, n4 / 2, n3, n4);
            drawable.draw(new Canvas(bitmap));
        }
        intent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)bitmap);
    }

    public Bundle g() {
        Bundle bundle = new Bundle();
        switch (this.b) {
            case 1: 
            case 5: {
                bundle.putParcelable(u, (Parcelable)((Bitmap)this.c));
                break;
            }
            case -1: {
                bundle.putParcelable(u, (Parcelable)this.c);
                break;
            }
            case 2: 
            case 4: {
                bundle.putString(u, (String)this.c);
                break;
            }
            case 3: {
                bundle.putByteArray(u, (byte[])this.c);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid icon");
            }
        }
        bundle.putInt(t, this.b);
        bundle.putInt(v, this.f);
        bundle.putInt(w, this.g);
        if (this.h != null) {
            bundle.putParcelable(x, (Parcelable)this.h);
        }
        if (this.j != i) {
            bundle.putString(y, this.j.name());
        }
        return bundle;
    }

    public String toString() {
        if (this.b == -1) {
            return String.valueOf(this.c);
        }
        StringBuilder stringBuilder = new StringBuilder("Icon(typ=").append(IconCompat.b(this.b));
        switch (this.b) {
            case 1: 
            case 5: {
                stringBuilder.append(" size=").append(((Bitmap)this.c).getWidth()).append("x").append(((Bitmap)this.c).getHeight());
                break;
            }
            case 2: {
                stringBuilder.append(" pkg=").append(this.b()).append(" id=").append(String.format("0x%08x", this.c()));
                break;
            }
            case 3: {
                stringBuilder.append(" len=").append(this.f);
                if (this.g == 0) break;
                stringBuilder.append(" off=").append(this.g);
                break;
            }
            case 4: {
                stringBuilder.append(" uri=").append(this.c);
            }
        }
        if (this.h != null) {
            stringBuilder.append(" tint=");
            stringBuilder.append(this.h);
        }
        if (this.j != i) {
            stringBuilder.append(" mode=").append(this.j);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void a(boolean bl) {
        this.k = this.j.name();
        switch (this.b) {
            case -1: {
                if (bl) {
                    throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
                }
                this.e = (Parcelable)this.c;
                break;
            }
            case 1: 
            case 5: {
                if (bl) {
                    Bitmap bitmap = (Bitmap)this.c;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)byteArrayOutputStream);
                    this.d = byteArrayOutputStream.toByteArray();
                    break;
                }
                this.e = (Parcelable)this.c;
                break;
            }
            case 4: {
                this.d = this.c.toString().getBytes(Charset.forName("UTF-16"));
                break;
            }
            case 2: {
                this.d = ((String)this.c).getBytes(Charset.forName("UTF-16"));
                break;
            }
            case 3: {
                this.d = (byte[])this.c;
            }
        }
    }

    public void h() {
        this.j = PorterDuff.Mode.valueOf((String)this.k);
        switch (this.b) {
            case -1: {
                if (this.e != null) {
                    this.c = this.e;
                    break;
                }
                throw new IllegalArgumentException("Invalid icon");
            }
            case 1: 
            case 5: {
                if (this.e != null) {
                    this.c = this.e;
                    break;
                }
                this.c = this.d;
                this.b = 3;
                this.f = 0;
                this.g = this.d.length;
                break;
            }
            case 2: 
            case 4: {
                this.c = new String(this.d, Charset.forName("UTF-16"));
                break;
            }
            case 3: {
                this.c = this.d;
            }
        }
    }

    private static String b(int n2) {
        switch (n2) {
            case 1: {
                return "BITMAP";
            }
            case 5: {
                return "BITMAP_MASKABLE";
            }
            case 3: {
                return "DATA";
            }
            case 2: {
                return "RESOURCE";
            }
            case 4: {
                return "URI";
            }
        }
        return "UNKNOWN";
    }

    @M
    public static IconCompat a(@L Bundle bundle) {
        int n2 = bundle.getInt(t);
        IconCompat iconCompat = new IconCompat(n2);
        iconCompat.f = bundle.getInt(v);
        iconCompat.g = bundle.getInt(w);
        if (bundle.containsKey(x)) {
            iconCompat.h = (ColorStateList)bundle.getParcelable(x);
        }
        if (bundle.containsKey(y)) {
            iconCompat.j = PorterDuff.Mode.valueOf((String)bundle.getString(y));
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 5: {
                iconCompat.c = bundle.getParcelable(u);
                break;
            }
            case 2: 
            case 4: {
                iconCompat.c = bundle.getString(u);
                break;
            }
            case 3: {
                iconCompat.c = bundle.getByteArray(u);
                break;
            }
            default: {
                Log.w((String)l, (String)("Unknown type " + n2));
                return null;
            }
        }
        return iconCompat;
    }

    @Q(a=23)
    @M
    public static IconCompat a(@L Context context, @L Icon icon) {
        androidx.core.m.l.a(icon);
        switch (IconCompat.b(icon)) {
            case 2: {
                String string = IconCompat.c(icon);
                try {
                    return IconCompat.a(IconCompat.a(context, string), string, IconCompat.d(icon));
                }
                catch (Resources.NotFoundException notFoundException) {
                    throw new IllegalArgumentException("Icon resource cannot be found");
                }
            }
            case 4: {
                return IconCompat.a(IconCompat.e(icon));
            }
        }
        IconCompat iconCompat = new IconCompat(-1);
        iconCompat.c = icon;
        return iconCompat;
    }

    @V(a={W.c})
    @Q(a=23)
    @M
    public static IconCompat a(@L Icon icon) {
        androidx.core.m.l.a(icon);
        switch (IconCompat.b(icon)) {
            case 2: {
                return IconCompat.a(null, IconCompat.c(icon), IconCompat.d(icon));
            }
            case 4: {
                return IconCompat.a(IconCompat.e(icon));
            }
        }
        IconCompat iconCompat = new IconCompat(-1);
        iconCompat.c = icon;
        return iconCompat;
    }

    @Q(a=23)
    private static int b(@L Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getType();
        }
        try {
            return (Integer)icon.getClass().getMethod("getType", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)l, (String)("Unable to get icon type " + icon), (Throwable)illegalAccessException);
            return -1;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)l, (String)("Unable to get icon type " + icon), (Throwable)invocationTargetException);
            return -1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)l, (String)("Unable to get icon type " + icon), (Throwable)noSuchMethodException);
            return -1;
        }
    }

    @M
    @Q(a=23)
    private static String c(@L Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResPackage();
        }
        try {
            return (String)icon.getClass().getMethod("getResPackage", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)l, (String)"Unable to get icon package", (Throwable)illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)l, (String)"Unable to get icon package", (Throwable)invocationTargetException);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)l, (String)"Unable to get icon package", (Throwable)noSuchMethodException);
            return null;
        }
    }

    @w
    @Q(a=23)
    @q
    private static int d(@L Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getResId();
        }
        try {
            return (Integer)icon.getClass().getMethod("getResId", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)l, (String)"Unable to get icon resource", (Throwable)illegalAccessException);
            return 0;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)l, (String)"Unable to get icon resource", (Throwable)invocationTargetException);
            return 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)l, (String)"Unable to get icon resource", (Throwable)noSuchMethodException);
            return 0;
        }
    }

    @M
    @Q(a=23)
    private static Uri e(@L Icon icon) {
        if (Build.VERSION.SDK_INT >= 28) {
            return icon.getUri();
        }
        try {
            return (Uri)icon.getClass().getMethod("getUri", new Class[0]).invoke((Object)icon, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)l, (String)"Unable to get icon uri", (Throwable)illegalAccessException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)l, (String)"Unable to get icon uri", (Throwable)invocationTargetException);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)l, (String)"Unable to get icon uri", (Throwable)noSuchMethodException);
            return null;
        }
    }

    @ae
    static Bitmap a(Bitmap bitmap, boolean bl) {
        int n2 = (int)(0.6666667f * (float)Math.min(bitmap.getWidth(), bitmap.getHeight()));
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint(3);
        float f2 = (float)n2 * 0.5f;
        float f3 = f2 * 0.9166667f;
        if (bl) {
            float f4 = 0.010416667f * (float)n2;
            paint.setColor(0);
            paint.setShadowLayer(f4, 0.0f, 0.020833334f * (float)n2, 0x3D000000);
            canvas.drawCircle(f2, f2, f3, paint);
            paint.setShadowLayer(f4, 0.0f, 0.0f, 0x1E000000);
            canvas.drawCircle(f2, f2, f3, paint);
            paint.clearShadowLayer();
        }
        paint.setColor(-16777216);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Matrix matrix = new Matrix();
        matrix.setTranslate((float)(-(bitmap.getWidth() - n2) / 2), (float)(-(bitmap.getHeight() - n2) / 2));
        bitmapShader.setLocalMatrix(matrix);
        paint.setShader((Shader)bitmapShader);
        canvas.drawCircle(f2, f2, f3, paint);
        canvas.setBitmap(null);
        return bitmap2;
    }
}

