/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import androidx.a.L;
import androidx.a.M;
import androidx.a.V;
import androidx.a.W;
import androidx.core.n.F;
import androidx.core.n.G;
import androidx.core.n.J;
import androidx.core.n.K;
import androidx.core.n.P;
import androidx.core.n.S;
import androidx.core.widget.i;
import androidx.core.widget.n;
import androidx.core.widget.o;
import androidx.core.widget.p;
import java.util.ArrayList;

public class NestedScrollView
extends FrameLayout
implements F,
J,
P {
    static final int a = 250;
    static final float b = 0.5f;
    private static final String c = "NestedScrollView";
    private long d;
    private final Rect e = new Rect();
    private OverScroller f;
    private EdgeEffect g;
    private EdgeEffect h;
    private int i;
    private boolean j = true;
    private boolean k = false;
    private View l = null;
    private boolean m = false;
    private VelocityTracker n;
    private boolean o;
    private boolean p = true;
    private int q;
    private int r;
    private int s;
    private int t = -1;
    private final int[] u = new int[2];
    private final int[] v = new int[2];
    private int w;
    private int x;
    private static final int y = -1;
    private p z;
    private static final n A = new n();
    private static final int[] B = new int[]{16843130};
    private final K C;
    private final G D;
    private float E;
    private o F;

    public NestedScrollView(@L Context context) {
        this(context, null);
    }

    public NestedScrollView(@L Context context, @M AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public NestedScrollView(@L Context context, @M AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.e();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, B, n2, 0);
        this.a(typedArray.getBoolean(0, false));
        typedArray.recycle();
        this.C = new K((ViewGroup)this);
        this.D = new G((View)this);
        this.setNestedScrollingEnabled(true);
        S.a((View)this, A);
    }

    @Override
    public void a(int n2, int n3, int n4, int n5, @M int[] nArray, int n6, @L int[] nArray2) {
        this.D.a(n2, n3, n4, n5, nArray, n6, nArray2);
    }

    @Override
    public boolean a(int n2, int n3) {
        return this.D.a(n2, n3);
    }

    @Override
    public void a(int n2) {
        this.D.c(n2);
    }

    @Override
    public boolean b(int n2) {
        return this.D.a(n2);
    }

    @Override
    public boolean a(int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        return this.D.a(n2, n3, n4, n5, nArray, n6);
    }

    @Override
    public boolean a(int n2, int n3, int[] nArray, int[] nArray2, int n4) {
        return this.D.a(n2, n3, nArray, nArray2, n4);
    }

    @Override
    public void setNestedScrollingEnabled(boolean bl) {
        this.D.a(bl);
    }

    @Override
    public boolean isNestedScrollingEnabled() {
        return this.D.a();
    }

    @Override
    public boolean startNestedScroll(int n2) {
        return this.a(n2, 0);
    }

    @Override
    public void stopNestedScroll() {
        this.a(0);
    }

    @Override
    public boolean hasNestedScrollingParent() {
        return this.b(0);
    }

    @Override
    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray) {
        return this.D.a(n2, n3, n4, n5, nArray);
    }

    @Override
    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2) {
        return this.a(n2, n3, nArray, nArray2, 0);
    }

    @Override
    public boolean dispatchNestedFling(float f2, float f3, boolean bl) {
        return this.D.a(f2, f3, bl);
    }

    @Override
    public boolean dispatchNestedPreFling(float f2, float f3) {
        return this.D.a(f2, f3);
    }

    @Override
    public void a(@L View view, int n2, int n3, int n4, int n5, int n6, @L int[] nArray) {
        this.a(n5, n6, nArray);
    }

    private void a(int n2, int n3, @M int[] nArray) {
        int n4 = this.getScrollY();
        this.scrollBy(0, n2);
        int n5 = this.getScrollY() - n4;
        if (nArray != null) {
            nArray[1] = nArray[1] + n5;
        }
        int n6 = n2 - n5;
        this.D.a(0, n5, 0, n6, null, n3, nArray);
    }

    @Override
    public boolean a(@L View view, @L View view2, int n2, int n3) {
        return (n2 & 2) != 0;
    }

    @Override
    public void b(@L View view, @L View view2, int n2, int n3) {
        this.C.a(view, view2, n2, n3);
        this.a(2, n3);
    }

    @Override
    public void a(@L View view, int n2) {
        this.C.a(view, n2);
        this.a(n2);
    }

    @Override
    public void a(@L View view, int n2, int n3, int n4, int n5, int n6) {
        this.a(n5, n6, null);
    }

    @Override
    public void a(@L View view, int n2, int n3, @L int[] nArray, int n4) {
        this.a(n2, n3, nArray, null, n4);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n2) {
        return this.a(view, view2, n2, 0);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n2) {
        this.b(view, view2, n2, 0);
    }

    @Override
    public void onStopNestedScroll(View view) {
        this.a(view, 0);
    }

    @Override
    public void onNestedScroll(View view, int n2, int n3, int n4, int n5) {
        this.a(n5, 0, null);
    }

    @Override
    public void onNestedPreScroll(View view, int n2, int n3, int[] nArray) {
        this.a(view, n2, n3, nArray, 0);
    }

    @Override
    public boolean onNestedFling(View view, float f2, float f3, boolean bl) {
        if (!bl) {
            this.dispatchNestedFling(0.0f, f3, true);
            this.f((int)f3);
            return true;
        }
        return false;
    }

    @Override
    public boolean onNestedPreFling(View view, float f2, float f3) {
        return this.dispatchNestedPreFling(f2, f3);
    }

    @Override
    public int getNestedScrollAxes() {
        return this.C.a();
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    protected float getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n2 = this.getVerticalFadingEdgeLength();
        int n3 = this.getScrollY();
        if (n3 < n2) {
            return (float)n3 / (float)n2;
        }
        return 1.0f;
    }

    protected float getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        View view = this.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        int n2 = this.getVerticalFadingEdgeLength();
        int n3 = this.getHeight() - this.getPaddingBottom();
        int n4 = view.getBottom() + layoutParams.bottomMargin - this.getScrollY() - n3;
        if (n4 < n2) {
            return (float)n4 / (float)n2;
        }
        return 1.0f;
    }

    public int a() {
        return (int)(0.5f * (float)this.getHeight());
    }

    private void e() {
        this.f = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.q = viewConfiguration.getScaledTouchSlop();
        this.r = viewConfiguration.getScaledMinimumFlingVelocity();
        this.s = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    public void addView(View view) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view);
    }

    public void addView(View view, int n2) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, n2);
    }

    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, layoutParams);
    }

    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, n2, layoutParams);
    }

    public void a(@M o o2) {
        this.F = o2;
    }

    private boolean f() {
        if (this.getChildCount() > 0) {
            int n2;
            View view = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            int n3 = view.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            return n3 > (n2 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        }
        return false;
    }

    public boolean b() {
        return this.o;
    }

    public void a(boolean bl) {
        if (bl != this.o) {
            this.o = bl;
            this.requestLayout();
        }
    }

    public boolean c() {
        return this.p;
    }

    public void b(boolean bl) {
        this.p = bl;
    }

    protected void onScrollChanged(int n2, int n3, int n4, int n5) {
        super.onScrollChanged(n2, n3, n4, n5);
        if (this.F != null) {
            this.F.a(this, n2, n3, n4, n5);
        }
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        if (!this.o) {
            return;
        }
        int n4 = View.MeasureSpec.getMode((int)n3);
        if (n4 == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            int n5;
            View view = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            int n6 = view.getMeasuredHeight();
            if (n6 < (n5 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom() - layoutParams.topMargin - layoutParams.bottomMargin)) {
                int n7 = NestedScrollView.getChildMeasureSpec((int)n2, (int)(this.getPaddingLeft() + this.getPaddingRight() + layoutParams.leftMargin + layoutParams.rightMargin), (int)layoutParams.width);
                int n8 = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
                view.measure(n7, n8);
            }
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.a(keyEvent);
    }

    public boolean a(@L KeyEvent keyEvent) {
        this.e.setEmpty();
        if (!this.f()) {
            if (this.isFocused() && keyEvent.getKeyCode() != 4) {
                View view;
                View view2 = this.findFocus();
                if (view2 == this) {
                    view2 = null;
                }
                return (view = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view2, 130)) != null && view != this && view.requestFocus(130);
            }
            return false;
        }
        boolean bl = false;
        if (keyEvent.getAction() == 0) {
            switch (keyEvent.getKeyCode()) {
                case 19: {
                    if (!keyEvent.isAltPressed()) {
                        bl = this.e(33);
                        break;
                    }
                    bl = this.d(33);
                    break;
                }
                case 20: {
                    if (!keyEvent.isAltPressed()) {
                        bl = this.e(130);
                        break;
                    }
                    bl = this.d(130);
                    break;
                }
                case 62: {
                    this.c(keyEvent.isShiftPressed() ? 33 : 130);
                }
            }
        }
        return bl;
    }

    private boolean d(int n2, int n3) {
        if (this.getChildCount() > 0) {
            int n4 = this.getScrollY();
            View view = this.getChildAt(0);
            return n3 >= view.getTop() - n4 && n3 < view.getBottom() - n4 && n2 >= view.getLeft() && n2 < view.getRight();
        }
        return false;
    }

    private void g() {
        if (this.n == null) {
            this.n = VelocityTracker.obtain();
        } else {
            this.n.clear();
        }
    }

    private void h() {
        if (this.n == null) {
            this.n = VelocityTracker.obtain();
        }
    }

    private void i() {
        if (this.n != null) {
            this.n.recycle();
            this.n = null;
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        if (bl) {
            this.i();
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        if (n2 == 2 && this.m) {
            return true;
        }
        switch (n2 & 0xFF) {
            case 2: {
                int n3 = this.t;
                if (n3 == -1) break;
                int n4 = motionEvent.findPointerIndex(n3);
                if (n4 == -1) {
                    Log.e((String)c, (String)("Invalid pointerId=" + n3 + " in onInterceptTouchEvent"));
                    break;
                }
                int n5 = (int)motionEvent.getY(n4);
                int n6 = Math.abs(n5 - this.i);
                if (n6 <= this.q || (this.getNestedScrollAxes() & 2) != 0) break;
                this.m = true;
                this.i = n5;
                this.h();
                this.n.addMovement(motionEvent);
                this.w = 0;
                ViewParent viewParent = this.getParent();
                if (viewParent == null) break;
                viewParent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int n7 = (int)motionEvent.getY();
                if (!this.d((int)motionEvent.getX(), n7)) {
                    this.m = false;
                    this.i();
                    break;
                }
                this.i = n7;
                this.t = motionEvent.getPointerId(0);
                this.g();
                this.n.addMovement(motionEvent);
                this.f.computeScrollOffset();
                this.m = !this.f.isFinished();
                this.a(2, 0);
                break;
            }
            case 1: 
            case 3: {
                this.m = false;
                this.t = -1;
                this.i();
                if (this.f.springBack(this.getScrollX(), this.getScrollY(), 0, 0, 0, this.d())) {
                    S.h((View)this);
                }
                this.a(0);
                break;
            }
            case 6: {
                this.a(motionEvent);
            }
        }
        return this.m;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.h();
        int n2 = motionEvent.getActionMasked();
        if (n2 == 0) {
            this.w = 0;
        }
        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent2.offsetLocation(0.0f, (float)this.w);
        switch (n2) {
            case 0: {
                ViewParent viewParent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                this.m = !this.f.isFinished();
                if (this.m && (viewParent = this.getParent()) != null) {
                    viewParent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.f.isFinished()) {
                    this.k();
                }
                this.i = (int)motionEvent.getY();
                this.t = motionEvent.getPointerId(0);
                this.a(2, 0);
                break;
            }
            case 2: {
                boolean bl;
                int n3 = motionEvent.findPointerIndex(this.t);
                if (n3 == -1) {
                    Log.e((String)c, (String)("Invalid pointerId=" + this.t + " in onTouchEvent"));
                    break;
                }
                int n4 = (int)motionEvent.getY(n3);
                int n5 = this.i - n4;
                if (this.a(0, n5, this.v, this.u, 0)) {
                    n5 -= this.v[1];
                    this.w += this.u[1];
                }
                if (!this.m && Math.abs(n5) > this.q) {
                    ViewParent viewParent = this.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.m = true;
                    n5 = n5 > 0 ? (n5 -= this.q) : (n5 += this.q);
                }
                if (!this.m) break;
                this.i = n4 - this.u[1];
                int n6 = this.getScrollY();
                int n7 = this.d();
                int n8 = this.getOverScrollMode();
                boolean bl2 = bl = n8 == 0 || n8 == 1 && n7 > 0;
                if (this.a(0, n5, 0, this.getScrollY(), 0, n7, 0, 0, true) && !this.b(0)) {
                    this.n.clear();
                }
                int n9 = this.getScrollY() - n6;
                int n10 = n5 - n9;
                this.v[1] = 0;
                this.a(0, n9, 0, n10, this.u, 0, this.v);
                this.i -= this.u[1];
                this.w += this.u[1];
                if (!bl) break;
                this.m();
                int n11 = n6 + (n5 -= this.v[1]);
                if (n11 < 0) {
                    androidx.core.widget.i.a(this.g, (float)n5 / (float)this.getHeight(), motionEvent.getX(n3) / (float)this.getWidth());
                    if (!this.h.isFinished()) {
                        this.h.onRelease();
                    }
                } else if (n11 > n7) {
                    androidx.core.widget.i.a(this.h, (float)n5 / (float)this.getHeight(), 1.0f - motionEvent.getX(n3) / (float)this.getWidth());
                    if (!this.g.isFinished()) {
                        this.g.onRelease();
                    }
                }
                if (this.g == null || this.g.isFinished() && this.h.isFinished()) break;
                S.h((View)this);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.n;
                velocityTracker.computeCurrentVelocity(1000, (float)this.s);
                int n12 = (int)velocityTracker.getYVelocity(this.t);
                if (Math.abs(n12) > this.r) {
                    if (!this.dispatchNestedPreFling(0.0f, -n12)) {
                        this.dispatchNestedFling(0.0f, -n12, true);
                        this.f(-n12);
                    }
                } else if (this.f.springBack(this.getScrollX(), this.getScrollY(), 0, 0, 0, this.d())) {
                    S.h((View)this);
                }
                this.t = -1;
                this.l();
                break;
            }
            case 3: {
                if (this.m && this.getChildCount() > 0 && this.f.springBack(this.getScrollX(), this.getScrollY(), 0, 0, 0, this.d())) {
                    S.h((View)this);
                }
                this.t = -1;
                this.l();
                break;
            }
            case 5: {
                int n13 = motionEvent.getActionIndex();
                this.i = (int)motionEvent.getY(n13);
                this.t = motionEvent.getPointerId(n13);
                break;
            }
            case 6: {
                this.a(motionEvent);
                this.i = (int)motionEvent.getY(motionEvent.findPointerIndex(this.t));
            }
        }
        if (this.n != null) {
            this.n.addMovement(motionEvent2);
        }
        motionEvent2.recycle();
        return true;
    }

    private void a(MotionEvent motionEvent) {
        int n2 = motionEvent.getActionIndex();
        int n3 = motionEvent.getPointerId(n2);
        if (n3 == this.t) {
            int n4 = n2 == 0 ? 1 : 0;
            this.i = (int)motionEvent.getY(n4);
            this.t = motionEvent.getPointerId(n4);
            if (this.n != null) {
                this.n.clear();
            }
        }
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((motionEvent.getSource() & 2) != 0) {
            switch (motionEvent.getAction()) {
                case 8: {
                    float f2;
                    if (this.m || (f2 = motionEvent.getAxisValue(9)) == 0.0f) break;
                    int n2 = (int)(f2 * this.j());
                    int n3 = this.d();
                    int n4 = this.getScrollY();
                    int n5 = n4 - n2;
                    if (n5 < 0) {
                        n5 = 0;
                    } else if (n5 > n3) {
                        n5 = n3;
                    }
                    if (n5 == n4) break;
                    super.scrollTo(this.getScrollX(), n5);
                    return true;
                }
            }
        }
        return false;
    }

    private float j() {
        if (this.E == 0.0f) {
            TypedValue typedValue = new TypedValue();
            Context context = this.getContext();
            if (!context.getTheme().resolveAttribute(16842829, typedValue, true)) {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
            this.E = typedValue.getDimension(context.getResources().getDisplayMetrics());
        }
        return this.E;
    }

    protected void onOverScrolled(int n2, int n3, boolean bl, boolean bl2) {
        super.scrollTo(n2, n3);
    }

    boolean a(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        int n10 = this.getOverScrollMode();
        boolean bl2 = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent();
        boolean bl3 = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent();
        boolean bl4 = n10 == 0 || n10 == 1 && bl2;
        boolean bl5 = n10 == 0 || n10 == 1 && bl3;
        int n11 = n4 + n2;
        if (!bl4) {
            n8 = 0;
        }
        int n12 = n5 + n3;
        if (!bl5) {
            n9 = 0;
        }
        int n13 = -n8;
        int n14 = n8 + n6;
        int n15 = -n9;
        int n16 = n9 + n7;
        boolean bl6 = false;
        if (n11 > n14) {
            n11 = n14;
            bl6 = true;
        } else if (n11 < n13) {
            n11 = n13;
            bl6 = true;
        }
        boolean bl7 = false;
        if (n12 > n16) {
            n12 = n16;
            bl7 = true;
        } else if (n12 < n15) {
            n12 = n15;
            bl7 = true;
        }
        if (bl7 && !this.b(1)) {
            this.f.springBack(n11, n12, 0, 0, 0, this.d());
        }
        this.onOverScrolled(n11, n12, bl6, bl7);
        return bl6 || bl7;
    }

    int d() {
        int n2 = 0;
        if (this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            int n3 = view.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            int n4 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            n2 = Math.max(0, n3 - n4);
        }
        return n2;
    }

    private View a(boolean bl, int n2, int n3) {
        ArrayList arrayList = this.getFocusables(2);
        View view = null;
        boolean bl2 = false;
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            boolean bl3;
            boolean bl4;
            View view2 = (View)arrayList.get(i2);
            int n5 = view2.getTop();
            int n6 = view2.getBottom();
            if (n2 >= n6 || n5 >= n3) continue;
            boolean bl5 = bl4 = n2 < n5 && n6 < n3;
            if (view == null) {
                view = view2;
                bl2 = bl4;
                continue;
            }
            boolean bl6 = bl3 = bl && n5 < view.getTop() || !bl && n6 > view.getBottom();
            if (bl2) {
                if (!bl4 || !bl3) continue;
                view = view2;
                continue;
            }
            if (bl4) {
                view = view2;
                bl2 = true;
                continue;
            }
            if (!bl3) continue;
            view = view2;
        }
        return view;
    }

    public boolean c(int n2) {
        boolean bl = n2 == 130;
        int n3 = this.getHeight();
        if (bl) {
            this.e.top = this.getScrollY() + n3;
            int n4 = this.getChildCount();
            if (n4 > 0) {
                View view = this.getChildAt(n4 - 1);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
                int n5 = view.getBottom() + layoutParams.bottomMargin + this.getPaddingBottom();
                if (this.e.top + n3 > n5) {
                    this.e.top = n5 - n3;
                }
            }
        } else {
            this.e.top = this.getScrollY() - n3;
            if (this.e.top < 0) {
                this.e.top = 0;
            }
        }
        this.e.bottom = this.e.top + n3;
        return this.a(n2, this.e.top, this.e.bottom);
    }

    public boolean d(int n2) {
        int n3;
        boolean bl = n2 == 130;
        int n4 = this.getHeight();
        this.e.top = 0;
        this.e.bottom = n4;
        if (bl && (n3 = this.getChildCount()) > 0) {
            View view = this.getChildAt(n3 - 1);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            this.e.bottom = view.getBottom() + layoutParams.bottomMargin + this.getPaddingBottom();
            this.e.top = this.e.bottom - n4;
        }
        return this.a(n2, this.e.top, this.e.bottom);
    }

    private boolean a(int n2, int n3, int n4) {
        boolean bl = true;
        int n5 = this.getHeight();
        int n6 = this.getScrollY();
        int n7 = n6 + n5;
        boolean bl2 = n2 == 33;
        Object object = this.a(bl2, n3, n4);
        if (object == null) {
            object = this;
        }
        if (n3 >= n6 && n4 <= n7) {
            bl = false;
        } else {
            int n8 = bl2 ? n3 - n6 : n4 - n7;
            this.g(n8);
        }
        if (object != this.findFocus()) {
            object.requestFocus(n2);
        }
        return bl;
    }

    public boolean e(int n2) {
        int n3;
        View view = this.findFocus();
        if (view == this) {
            view = null;
        }
        View view2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view, n2);
        int n4 = this.a();
        if (view2 != null && this.a(view2, n4, this.getHeight())) {
            view2.getDrawingRect(this.e);
            this.offsetDescendantRectToMyCoords(view2, this.e);
            n3 = this.a(this.e);
            this.g(n3);
            view2.requestFocus(n2);
        } else {
            n3 = n4;
            if (n2 == 33 && this.getScrollY() < n3) {
                n3 = this.getScrollY();
            } else if (n2 == 130 && this.getChildCount() > 0) {
                View view3 = this.getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view3.getLayoutParams();
                int n5 = view3.getBottom() + layoutParams.bottomMargin;
                int n6 = this.getScrollY() + this.getHeight() - this.getPaddingBottom();
                n3 = Math.min(n5 - n6, n4);
            }
            if (n3 == 0) {
                return false;
            }
            this.g(n2 == 130 ? n3 : -n3);
        }
        if (view != null && view.isFocused() && this.a(view)) {
            n3 = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(n3);
        }
        return true;
    }

    private boolean a(View view) {
        return !this.a(view, 0, this.getHeight());
    }

    private boolean a(View view, int n2, int n3) {
        view.getDrawingRect(this.e);
        this.offsetDescendantRectToMyCoords(view, this.e);
        return this.e.bottom + n2 >= this.getScrollY() && this.e.top - n2 <= this.getScrollY() + n3;
    }

    private void g(int n2) {
        if (n2 != 0) {
            if (this.p) {
                this.b(0, n2);
            } else {
                this.scrollBy(0, n2);
            }
        }
    }

    public final void b(int n2, int n3) {
        if (this.getChildCount() == 0) {
            return;
        }
        long l2 = AnimationUtils.currentAnimationTimeMillis() - this.d;
        if (l2 > 250L) {
            View view = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            int n4 = view.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            int n5 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int n6 = this.getScrollY();
            int n7 = Math.max(0, n4 - n5);
            n3 = Math.max(0, Math.min(n6 + n3, n7)) - n6;
            this.f.startScroll(this.getScrollX(), n6, 0, n3);
            this.c(false);
        } else {
            if (!this.f.isFinished()) {
                this.k();
            }
            this.scrollBy(n2, n3);
        }
        this.d = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void c(int n2, int n3) {
        this.b(n2 - this.getScrollX(), n3 - this.getScrollY());
    }

    @Override
    @V(a={W.c})
    public int computeVerticalScrollRange() {
        int n2 = this.getChildCount();
        int n3 = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (n2 == 0) {
            return n3;
        }
        View view = this.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        int n4 = view.getBottom() + layoutParams.bottomMargin;
        int n5 = this.getScrollY();
        int n6 = Math.max(0, n4 - n3);
        if (n5 < 0) {
            n4 -= n5;
        } else if (n5 > n6) {
            n4 += n5 - n6;
        }
        return n4;
    }

    @Override
    @V(a={W.c})
    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @Override
    @V(a={W.c})
    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @Override
    @V(a={W.c})
    public int computeHorizontalScrollRange() {
        return super.computeHorizontalScrollRange();
    }

    @Override
    @V(a={W.c})
    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    @Override
    @V(a={W.c})
    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    protected void measureChild(View view, int n2, int n3) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        int n4 = NestedScrollView.getChildMeasureSpec((int)n2, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)layoutParams.width);
        int n5 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(n4, n5);
    }

    protected void measureChildWithMargins(View view, int n2, int n3, int n4, int n5) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        int n6 = NestedScrollView.getChildMeasureSpec((int)n2, (int)(this.getPaddingLeft() + this.getPaddingRight() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + n3), (int)marginLayoutParams.width);
        int n7 = View.MeasureSpec.makeMeasureSpec((int)(marginLayoutParams.topMargin + marginLayoutParams.bottomMargin), (int)0);
        view.measure(n6, n7);
    }

    public void computeScroll() {
        int n2;
        int n3;
        if (this.f.isFinished()) {
            return;
        }
        this.f.computeScrollOffset();
        int n4 = this.f.getCurrY();
        int n5 = n4 - this.x;
        this.x = n4;
        this.v[1] = 0;
        this.a(0, n5, this.v, null, 1);
        int n6 = this.d();
        if ((n5 -= this.v[1]) != 0) {
            n3 = this.getScrollY();
            this.a(0, n5, this.getScrollX(), n3, 0, n6, 0, 0, false);
            n2 = this.getScrollY() - n3;
            this.v[1] = 0;
            this.a(0, n2, 0, n5 -= n2, this.u, 1, this.v);
            n5 -= this.v[1];
        }
        if (n5 != 0) {
            n3 = this.getOverScrollMode();
            int n7 = n2 = n3 == 0 || n3 == 1 && n6 > 0 ? 1 : 0;
            if (n2 != 0) {
                this.m();
                if (n5 < 0) {
                    if (this.g.isFinished()) {
                        this.g.onAbsorb((int)this.f.getCurrVelocity());
                    }
                } else if (this.h.isFinished()) {
                    this.h.onAbsorb((int)this.f.getCurrVelocity());
                }
            }
            this.k();
        }
        if (!this.f.isFinished()) {
            S.h((View)this);
        }
    }

    private void c(boolean bl) {
        if (bl) {
            this.a(2, 1);
        } else {
            this.a(1);
        }
        this.x = this.getScrollY();
        S.h((View)this);
    }

    private void k() {
        this.f.abortAnimation();
        this.a(1);
    }

    private void b(View view) {
        view.getDrawingRect(this.e);
        this.offsetDescendantRectToMyCoords(view, this.e);
        int n2 = this.a(this.e);
        if (n2 != 0) {
            this.scrollBy(0, n2);
        }
    }

    private boolean a(Rect rect, boolean bl) {
        boolean bl2;
        int n2 = this.a(rect);
        boolean bl3 = bl2 = n2 != 0;
        if (bl2) {
            if (bl) {
                this.scrollBy(0, n2);
            } else {
                this.b(0, n2);
            }
        }
        return bl2;
    }

    protected int a(Rect rect) {
        int n2;
        if (this.getChildCount() == 0) {
            return 0;
        }
        int n3 = this.getHeight();
        int n4 = this.getScrollY();
        int n5 = n2 = n4 + n3;
        int n6 = this.getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            n4 += n6;
        }
        View view = this.getChildAt(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (rect.bottom < view.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin) {
            n2 -= n6;
        }
        int n7 = 0;
        if (rect.bottom > n2 && rect.top > n4) {
            n7 = rect.height() > n3 ? (n7 += rect.top - n4) : (n7 += rect.bottom - n2);
            int n8 = view.getBottom() + layoutParams.bottomMargin;
            int n9 = n8 - n5;
            n7 = Math.min(n7, n9);
        } else if (rect.top < n4 && rect.bottom < n2) {
            n7 = rect.height() > n3 ? (n7 -= n2 - rect.bottom) : (n7 -= n4 - rect.top);
            n7 = Math.max(n7, -this.getScrollY());
        }
        return n7;
    }

    public void requestChildFocus(View view, View view2) {
        if (!this.j) {
            this.b(view2);
        } else {
            this.l = view2;
        }
        super.requestChildFocus(view, view2);
    }

    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        View view;
        if (n2 == 2) {
            n2 = 130;
        } else if (n2 == 1) {
            n2 = 33;
        }
        View view2 = view = rect == null ? FocusFinder.getInstance().findNextFocus((ViewGroup)this, null, n2) : FocusFinder.getInstance().findNextFocusFromRect((ViewGroup)this, rect, n2);
        if (view == null) {
            return false;
        }
        if (this.a(view)) {
            return false;
        }
        return view.requestFocus(n2, rect);
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        rect.offset(view.getLeft() - view.getScrollX(), view.getTop() - view.getScrollY());
        return this.a(rect, bl);
    }

    public void requestLayout() {
        this.j = true;
        super.requestLayout();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.j = false;
        if (this.l != null && NestedScrollView.a(this.l, (View)this)) {
            this.b(this.l);
        }
        this.l = null;
        if (!this.k) {
            if (this.z != null) {
                this.scrollTo(this.getScrollX(), this.z.a);
                this.z = null;
            }
            int n6 = 0;
            if (this.getChildCount() > 0) {
                View view = this.getChildAt(0);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
                n6 = view.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
            int n7 = n5 - n3 - this.getPaddingTop() - this.getPaddingBottom();
            int n8 = this.getScrollY();
            int n9 = NestedScrollView.b(n8, n7, n6);
            if (n9 != n8) {
                this.scrollTo(this.getScrollX(), n9);
            }
        }
        this.scrollTo(this.getScrollX(), this.getScrollY());
        this.k = true;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.k = false;
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        View view = this.findFocus();
        if (null == view || this == view) {
            return;
        }
        if (this.a(view, 0, n5)) {
            view.getDrawingRect(this.e);
            this.offsetDescendantRectToMyCoords(view, this.e);
            int n6 = this.a(this.e);
            this.g(n6);
        }
    }

    private static boolean a(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent viewParent = view.getParent();
        return viewParent instanceof ViewGroup && NestedScrollView.a((View)viewParent, view2);
    }

    public void f(int n2) {
        if (this.getChildCount() > 0) {
            this.f.fling(this.getScrollX(), this.getScrollY(), 0, n2, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, 0);
            this.c(true);
        }
    }

    private void l() {
        this.m = false;
        this.i();
        this.a(0);
        if (this.g != null) {
            this.g.onRelease();
            this.h.onRelease();
        }
    }

    public void scrollTo(int n2, int n3) {
        if (this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
            int n4 = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int n5 = view.getWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            int n6 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int n7 = view.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            n2 = NestedScrollView.b(n2, n4, n5);
            n3 = NestedScrollView.b(n3, n6, n7);
            if (n2 != this.getScrollX() || n3 != this.getScrollY()) {
                super.scrollTo(n2, n3);
            }
        }
    }

    private void m() {
        if (this.getOverScrollMode() != 2) {
            if (this.g == null) {
                Context context = this.getContext();
                this.g = new EdgeEffect(context);
                this.h = new EdgeEffect(context);
            }
        } else {
            this.g = null;
            this.h = null;
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.g != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.getScrollY();
            if (!this.g.isFinished()) {
                n6 = canvas.save();
                n5 = this.getWidth();
                n4 = this.getHeight();
                n3 = 0;
                n2 = Math.min(0, n7);
                if (Build.VERSION.SDK_INT < 21 || this.getClipToPadding()) {
                    n5 -= this.getPaddingLeft() + this.getPaddingRight();
                    n3 += this.getPaddingLeft();
                }
                if (Build.VERSION.SDK_INT >= 21 && this.getClipToPadding()) {
                    n4 -= this.getPaddingTop() + this.getPaddingBottom();
                    n2 += this.getPaddingTop();
                }
                canvas.translate((float)n3, (float)n2);
                this.g.setSize(n5, n4);
                if (this.g.draw(canvas)) {
                    S.h((View)this);
                }
                canvas.restoreToCount(n6);
            }
            if (!this.h.isFinished()) {
                n6 = canvas.save();
                n5 = this.getWidth();
                n4 = this.getHeight();
                n3 = 0;
                n2 = Math.max(this.d(), n7) + n4;
                if (Build.VERSION.SDK_INT < 21 || this.getClipToPadding()) {
                    n5 -= this.getPaddingLeft() + this.getPaddingRight();
                    n3 += this.getPaddingLeft();
                }
                if (Build.VERSION.SDK_INT >= 21 && this.getClipToPadding()) {
                    n4 -= this.getPaddingTop() + this.getPaddingBottom();
                    n2 -= this.getPaddingBottom();
                }
                canvas.translate((float)(n3 - n5), (float)n2);
                canvas.rotate(180.0f, (float)n5, 0.0f);
                this.h.setSize(n5, n4);
                if (this.h.draw(canvas)) {
                    S.h((View)this);
                }
                canvas.restoreToCount(n6);
            }
        }
    }

    private static int b(int n2, int n3, int n4) {
        if (n3 >= n4 || n2 < 0) {
            return 0;
        }
        if (n3 + n2 > n4) {
            return n4 - n3;
        }
        return n2;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof p)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        p p2 = (p)parcelable;
        super.onRestoreInstanceState(p2.getSuperState());
        this.z = p2;
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        p p2 = new p(parcelable);
        p2.a = this.getScrollY();
        return p2;
    }
}

