/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.res.ColorStateList;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.icu.text.DecimalFormatSymbols;
import android.os.Build;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.method.PasswordTransformationMethod;
import android.util.Log;
import android.view.ActionMode;
import android.widget.TextView;
import androidx.a.C;
import androidx.a.L;
import androidx.a.M;
import androidx.a.O;
import androidx.a.Q;
import androidx.a.V;
import androidx.a.W;
import androidx.a.aa;
import androidx.a.q;
import androidx.core.l.f;
import androidx.core.l.g;
import androidx.core.l.h;
import androidx.core.m.l;
import androidx.core.widget.d;
import androidx.core.widget.w;
import androidx.core.widget.y;
import java.lang.reflect.Field;
import java.util.Locale;

public final class u {
    private static final String c = "TextViewCompat";
    public static final int a = 0;
    public static final int b = 1;
    private static Field d;
    private static boolean e;
    private static Field f;
    private static boolean g;
    private static Field h;
    private static boolean i;
    private static Field j;
    private static boolean k;
    private static final int l = 1;

    private u() {
    }

    private static Field a(String string) {
        Field field = null;
        try {
            field = TextView.class.getDeclaredField(string);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.e((String)c, (String)("Could not retrieve " + string + " field."));
        }
        return field;
    }

    private static int a(Field field, TextView textView) {
        try {
            return field.getInt(textView);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.d((String)c, (String)("Could not retrieve value of " + field.getName() + " field."));
            return -1;
        }
    }

    public static void a(@L TextView textView, @M Drawable drawable, @M Drawable drawable2, @M Drawable drawable3, @M Drawable drawable4) {
        if (Build.VERSION.SDK_INT >= 18) {
            textView.setCompoundDrawablesRelative(drawable, drawable2, drawable3, drawable4);
        } else if (Build.VERSION.SDK_INT >= 17) {
            boolean bl = textView.getLayoutDirection() == 1;
            textView.setCompoundDrawables(bl ? drawable3 : drawable, drawable2, bl ? drawable : drawable3, drawable4);
        } else {
            textView.setCompoundDrawables(drawable, drawable2, drawable3, drawable4);
        }
    }

    public static void b(@L TextView textView, @M Drawable drawable, @M Drawable drawable2, @M Drawable drawable3, @M Drawable drawable4) {
        if (Build.VERSION.SDK_INT >= 18) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        } else if (Build.VERSION.SDK_INT >= 17) {
            boolean bl = textView.getLayoutDirection() == 1;
            textView.setCompoundDrawablesWithIntrinsicBounds(bl ? drawable3 : drawable, drawable2, bl ? drawable : drawable3, drawable4);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(drawable, drawable2, drawable3, drawable4);
        }
    }

    public static void a(@L TextView textView, @q int n2, @q int n3, @q int n4, @q int n5) {
        if (Build.VERSION.SDK_INT >= 18) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(n2, n3, n4, n5);
        } else if (Build.VERSION.SDK_INT >= 17) {
            boolean bl = textView.getLayoutDirection() == 1;
            textView.setCompoundDrawablesWithIntrinsicBounds(bl ? n4 : n2, n3, bl ? n2 : n4, n5);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(n2, n3, n4, n5);
        }
    }

    public static int a(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 16) {
            return textView.getMaxLines();
        }
        if (!g) {
            f = u.a("mMaxMode");
            g = true;
        }
        if (f != null && u.a(f, textView) == 1) {
            if (!e) {
                d = u.a("mMaximum");
                e = true;
            }
            if (d != null) {
                return u.a(d, textView);
            }
        }
        return -1;
    }

    public static int b(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 16) {
            return textView.getMinLines();
        }
        if (!k) {
            j = u.a("mMinMode");
            k = true;
        }
        if (j != null && u.a(j, textView) == 1) {
            if (!i) {
                h = u.a("mMinimum");
                i = true;
            }
            if (h != null) {
                return u.a(h, textView);
            }
        }
        return -1;
    }

    public static void a(@L TextView textView, @aa int n2) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(n2);
        } else {
            textView.setTextAppearance(textView.getContext(), n2);
        }
    }

    @L
    public static Drawable[] c(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 18) {
            return textView.getCompoundDrawablesRelative();
        }
        if (Build.VERSION.SDK_INT >= 17) {
            boolean bl = textView.getLayoutDirection() == 1;
            Drawable[] drawableArray = textView.getCompoundDrawables();
            if (bl) {
                Drawable drawable = drawableArray[2];
                Drawable drawable2 = drawableArray[0];
                drawableArray[0] = drawable;
                drawableArray[2] = drawable2;
            }
            return drawableArray;
        }
        return textView.getCompoundDrawables();
    }

    public static void b(@L TextView textView, int n2) {
        if (Build.VERSION.SDK_INT >= 27) {
            textView.setAutoSizeTextTypeWithDefaults(n2);
        } else if (textView instanceof d) {
            ((d)textView).setAutoSizeTextTypeWithDefaults(n2);
        }
    }

    public static void b(@L TextView textView, int n2, int n3, int n4, int n5) {
        if (Build.VERSION.SDK_INT >= 27) {
            textView.setAutoSizeTextTypeUniformWithConfiguration(n2, n3, n4, n5);
        } else if (textView instanceof d) {
            ((d)textView).setAutoSizeTextTypeUniformWithConfiguration(n2, n3, n4, n5);
        }
    }

    public static void a(@L TextView textView, @L int[] nArray, int n2) {
        if (Build.VERSION.SDK_INT >= 27) {
            textView.setAutoSizeTextTypeUniformWithPresetSizes(nArray, n2);
        } else if (textView instanceof d) {
            ((d)textView).setAutoSizeTextTypeUniformWithPresetSizes(nArray, n2);
        }
    }

    public static int d(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 27) {
            return textView.getAutoSizeTextType();
        }
        if (textView instanceof d) {
            return ((d)textView).getAutoSizeTextType();
        }
        return 0;
    }

    public static int e(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 27) {
            return textView.getAutoSizeStepGranularity();
        }
        if (textView instanceof d) {
            return ((d)textView).getAutoSizeStepGranularity();
        }
        return -1;
    }

    public static int f(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 27) {
            return textView.getAutoSizeMinTextSize();
        }
        if (textView instanceof d) {
            return ((d)textView).getAutoSizeMinTextSize();
        }
        return -1;
    }

    public static int g(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 27) {
            return textView.getAutoSizeMaxTextSize();
        }
        if (textView instanceof d) {
            return ((d)textView).getAutoSizeMaxTextSize();
        }
        return -1;
    }

    @L
    public static int[] h(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 27) {
            return textView.getAutoSizeTextAvailableSizes();
        }
        if (textView instanceof d) {
            return ((d)textView).getAutoSizeTextAvailableSizes();
        }
        return new int[0];
    }

    public static void a(@L TextView textView, @L ActionMode.Callback callback) {
        textView.setCustomSelectionActionModeCallback(u.b(textView, callback));
    }

    @V(a={W.c})
    @L
    public static ActionMode.Callback b(@L TextView textView, @L ActionMode.Callback callback) {
        if (Build.VERSION.SDK_INT < 26 || Build.VERSION.SDK_INT > 27 || callback instanceof w) {
            return callback;
        }
        return new w(callback, textView);
    }

    public static void c(@L TextView textView, @O @C(a=0L) int n2) {
        androidx.core.m.l.a(n2);
        if (Build.VERSION.SDK_INT >= 28) {
            textView.setFirstBaselineToTopHeight(n2);
            return;
        }
        Paint.FontMetricsInt fontMetricsInt = textView.getPaint().getFontMetricsInt();
        int n3 = Build.VERSION.SDK_INT < 16 || textView.getIncludeFontPadding() ? fontMetricsInt.top : fontMetricsInt.ascent;
        if (n2 > Math.abs(n3)) {
            int n4 = n2 - -n3;
            textView.setPadding(textView.getPaddingLeft(), n4, textView.getPaddingRight(), textView.getPaddingBottom());
        }
    }

    public static void d(@L TextView textView, @O @C(a=0L) int n2) {
        androidx.core.m.l.a(n2);
        Paint.FontMetricsInt fontMetricsInt = textView.getPaint().getFontMetricsInt();
        int n3 = Build.VERSION.SDK_INT < 16 || textView.getIncludeFontPadding() ? fontMetricsInt.bottom : fontMetricsInt.descent;
        if (n2 > Math.abs(n3)) {
            int n4 = n2 - n3;
            textView.setPadding(textView.getPaddingLeft(), textView.getPaddingTop(), textView.getPaddingRight(), n4);
        }
    }

    public static int i(@L TextView textView) {
        return textView.getPaddingTop() - textView.getPaint().getFontMetricsInt().top;
    }

    public static int j(@L TextView textView) {
        return textView.getPaddingBottom() + textView.getPaint().getFontMetricsInt().bottom;
    }

    public static void e(@L TextView textView, @O @C(a=0L) int n2) {
        androidx.core.m.l.a(n2);
        int n3 = textView.getPaint().getFontMetricsInt(null);
        if (n2 != n3) {
            textView.setLineSpacing((float)(n2 - n3), 1.0f);
        }
    }

    @L
    public static g k(@L TextView textView) {
        if (Build.VERSION.SDK_INT >= 28) {
            return new g(textView.getTextMetricsParams());
        }
        h h2 = new h(new TextPaint((Paint)textView.getPaint()));
        if (Build.VERSION.SDK_INT >= 23) {
            h2.a(textView.getBreakStrategy());
            h2.b(textView.getHyphenationFrequency());
        }
        if (Build.VERSION.SDK_INT >= 18) {
            h2.a(u.n(textView));
        }
        return h2.a();
    }

    public static void a(@L TextView textView, @L g g2) {
        if (Build.VERSION.SDK_INT >= 18) {
            textView.setTextDirection(u.a(g2.b()));
        }
        if (Build.VERSION.SDK_INT < 23) {
            float f2 = g2.a().getTextScaleX();
            textView.getPaint().set(g2.a());
            if (f2 == textView.getTextScaleX()) {
                textView.setTextScaleX(f2 / 2.0f + 1.0f);
            }
            textView.setTextScaleX(f2);
        } else {
            textView.getPaint().set(g2.a());
            textView.setBreakStrategy(g2.c());
            textView.setHyphenationFrequency(g2.d());
        }
    }

    public static void a(@L TextView textView, @L f f2) {
        g g2 = u.k(textView);
        if (!g2.a(f2.b())) {
            throw new IllegalArgumentException("Given text can not be applied to TextView.");
        }
        textView.setText((CharSequence)((Object)f2));
    }

    @Q(a=18)
    private static TextDirectionHeuristic n(@L TextView textView) {
        if (textView.getTransformationMethod() instanceof PasswordTransformationMethod) {
            return TextDirectionHeuristics.LTR;
        }
        if (Build.VERSION.SDK_INT >= 28 && (textView.getInputType() & 0xF) == 3) {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance((Locale)textView.getTextLocale());
            String string = decimalFormatSymbols.getDigitStrings()[0];
            int n2 = string.codePointAt(0);
            byte by = Character.getDirectionality(n2);
            if (by == 1 || by == 2) {
                return TextDirectionHeuristics.RTL;
            }
            return TextDirectionHeuristics.LTR;
        }
        boolean bl = textView.getLayoutDirection() == 1;
        switch (textView.getTextDirection()) {
            default: {
                return bl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 2: {
                return TextDirectionHeuristics.ANYRTL_LTR;
            }
            case 3: {
                return TextDirectionHeuristics.LTR;
            }
            case 4: {
                return TextDirectionHeuristics.RTL;
            }
            case 5: {
                return TextDirectionHeuristics.LOCALE;
            }
            case 6: {
                return TextDirectionHeuristics.FIRSTSTRONG_LTR;
            }
            case 7: 
        }
        return TextDirectionHeuristics.FIRSTSTRONG_RTL;
    }

    @Q(a=18)
    private static int a(@L TextDirectionHeuristic textDirectionHeuristic) {
        if (textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_RTL) {
            return 1;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_LTR) {
            return 1;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.ANYRTL_LTR) {
            return 2;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.LTR) {
            return 3;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.RTL) {
            return 4;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.LOCALE) {
            return 5;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_LTR) {
            return 6;
        }
        if (textDirectionHeuristic == TextDirectionHeuristics.FIRSTSTRONG_RTL) {
            return 7;
        }
        return 1;
    }

    public static void a(@L TextView textView, @M ColorStateList colorStateList) {
        androidx.core.m.l.a(textView);
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setCompoundDrawableTintList(colorStateList);
        } else if (textView instanceof y) {
            ((y)textView).b(colorStateList);
        }
    }

    @M
    public static ColorStateList l(@L TextView textView) {
        androidx.core.m.l.a(textView);
        if (Build.VERSION.SDK_INT >= 23) {
            return textView.getCompoundDrawableTintList();
        }
        if (textView instanceof y) {
            return ((y)textView).h();
        }
        return null;
    }

    public static void a(@L TextView textView, @M PorterDuff.Mode mode) {
        androidx.core.m.l.a(textView);
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setCompoundDrawableTintMode(mode);
        } else if (textView instanceof y) {
            ((y)textView).b(mode);
        }
    }

    @M
    public static PorterDuff.Mode m(@L TextView textView) {
        androidx.core.m.l.a(textView);
        if (Build.VERSION.SDK_INT >= 23) {
            return textView.getCompoundDrawableTintMode();
        }
        if (textView instanceof y) {
            return ((y)textView).i();
        }
        return null;
    }
}

