/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.a.V;
import androidx.a.W;
import androidx.appcompat.n;
import androidx.appcompat.view.menu.I;
import androidx.appcompat.view.menu.b;
import androidx.appcompat.view.menu.c;
import androidx.appcompat.view.menu.r;
import androidx.appcompat.view.menu.u;
import androidx.appcompat.widget.aL;
import androidx.appcompat.widget.az;
import androidx.appcompat.widget.cr;

@V(a={W.c})
public class ActionMenuItemView
extends az
implements View.OnClickListener,
I,
androidx.appcompat.widget.u {
    private static final String e = "ActionMenuItemView";
    u a;
    private CharSequence f;
    private Drawable g;
    r b;
    private aL h;
    c c;
    private boolean i;
    private boolean j;
    private int k;
    private int l;
    private static final int m = 32;
    private int n;

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        Resources resources = context.getResources();
        this.i = this.j();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, androidx.appcompat.n.G, n2, 0);
        this.k = typedArray.getDimensionPixelSize(androidx.appcompat.n.H, 0);
        typedArray.recycle();
        float f2 = resources.getDisplayMetrics().density;
        this.n = (int)(32.0f * f2 + 0.5f);
        this.setOnClickListener(this);
        this.l = -1;
        this.setSaveEnabled(false);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.i = this.j();
        this.k();
    }

    private boolean j() {
        Configuration configuration = this.getContext().getResources().getConfiguration();
        int n2 = configuration.screenWidthDp;
        int n3 = configuration.screenHeightDp;
        return n2 >= 480 || n2 >= 640 && n3 >= 480 || configuration.orientation == 2;
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        this.l = n2;
        super.setPadding(n2, n3, n4, n5);
    }

    @Override
    public u a() {
        return this.a;
    }

    @Override
    public void a(u u2, int n2) {
        this.a = u2;
        this.a(u2.getIcon());
        this.a(u2.a(this));
        this.setId(u2.getItemId());
        this.setVisibility(u2.isVisible() ? 0 : 8);
        this.setEnabled(u2.isEnabled());
        if (u2.hasSubMenu() && this.h == null) {
            this.h = new b(this);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.a.hasSubMenu() && this.h != null && this.h.onTouch((View)this, motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void onClick(View view) {
        if (this.b != null) {
            this.b.a(this.a);
        }
    }

    public void a(r r2) {
        this.b = r2;
    }

    public void a(c c2) {
        this.c = c2;
    }

    @Override
    public boolean b() {
        return true;
    }

    @Override
    public void a(boolean bl) {
    }

    @Override
    public void b(boolean bl) {
    }

    public void c(boolean bl) {
        if (this.j != bl) {
            this.j = bl;
            if (this.a != null) {
                this.a.k();
            }
        }
    }

    private void k() {
        boolean bl = !TextUtils.isEmpty((CharSequence)this.f);
        this.setText((bl &= this.g == null || this.a.o() && (this.i || this.j)) ? this.f : null);
        CharSequence charSequence = this.a.getContentDescription();
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            this.setContentDescription(bl ? null : this.a.getTitle());
        } else {
            this.setContentDescription(charSequence);
        }
        CharSequence charSequence2 = this.a.getTooltipText();
        if (TextUtils.isEmpty((CharSequence)charSequence2)) {
            cr.a((View)this, bl ? null : this.a.getTitle());
        } else {
            cr.a((View)this, charSequence2);
        }
    }

    @Override
    public void a(Drawable drawable) {
        this.g = drawable;
        if (drawable != null) {
            float f2;
            int n2 = drawable.getIntrinsicWidth();
            int n3 = drawable.getIntrinsicHeight();
            if (n2 > this.n) {
                f2 = (float)this.n / (float)n2;
                n2 = this.n;
                n3 = (int)((float)n3 * f2);
            }
            if (n3 > this.n) {
                f2 = (float)this.n / (float)n3;
                n3 = this.n;
                n2 = (int)((float)n2 * f2);
            }
            drawable.setBounds(0, 0, n2, n3);
        }
        this.setCompoundDrawables(drawable, null, null, null);
        this.k();
    }

    public boolean c() {
        return !TextUtils.isEmpty((CharSequence)this.getText());
    }

    @Override
    public void a(boolean bl, char c2) {
    }

    @Override
    public void a(CharSequence charSequence) {
        this.f = charSequence;
        this.k();
    }

    @Override
    public boolean d() {
        return true;
    }

    @Override
    public boolean e() {
        return this.c() && this.a.getIcon() == null;
    }

    @Override
    public boolean f() {
        return this.c();
    }

    @Override
    protected void onMeasure(int n2, int n3) {
        int n4;
        boolean bl = this.c();
        if (bl && this.l >= 0) {
            super.setPadding(this.l, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        super.onMeasure(n2, n3);
        int n5 = View.MeasureSpec.getMode((int)n2);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = this.getMeasuredWidth();
        int n8 = n4 = n5 == Integer.MIN_VALUE ? Math.min(n6, this.k) : this.k;
        if (n5 != 0x40000000 && this.k > 0 && n7 < n4) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000), n3);
        }
        if (!bl && this.g != null) {
            int n9 = this.getMeasuredWidth();
            int n10 = this.g.getBounds().width();
            super.setPadding((n9 - n10) / 2, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(null);
    }
}

